/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.component.InvalidComponentException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.craftbook.mechanic.MechanicCommands;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;

public final class MechanicCommandsRegistration
implements CommandRegistration<MechanicCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<MechanicType<?>> mechanicType$__Key = Key.of((TypeToken)new TypeToken<MechanicType<?>>(){});
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private MechanicCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument mechanicTypePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mechanicType"), (Component)TextComponent.of((String)"The mechanic to enable")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mechanicType$__Key)).build();
    private final ArgAcceptingCommandFlag listBoxPagePart = CommandParts.flag((char)'l', (Component)TextComponent.of((String)"Show the list box")).withRequiredArg().argNamed(TranslatableComponent.of((String)"listBoxPage")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument mechanicTypePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mechanicType"), (Component)TextComponent.of((String)"The mechanic to disable")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mechanicType$__Key)).build();
    private final CommandArgument mechanicTypePart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mechanicType"), (Component)TextComponent.of((String)"The mechanic to reload")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mechanicType$__Key)).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The page number")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();

    private MechanicCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static MechanicCommandsRegistration builder() {
        return new MechanicCommandsRegistration();
    }

    public MechanicCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public MechanicCommandsRegistration containerInstance(MechanicCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public MechanicCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public MechanicCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("enable", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Enable a mechanic"));
            b.parts((Collection)ImmutableList.of((Object)this.mechanicTypePart, (Object)this.listBoxPagePart));
            b.action(this::cmd$enable);
            Method commandMethod = RegistrationUtil.getCommandMethod(MechanicCommands.class, (String)"enable", (Class[])new Class[]{Actor.class, MechanicType.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("disable", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Disable a mechanic"));
            b.parts((Collection)ImmutableList.of((Object)this.mechanicTypePart2, (Object)this.listBoxPagePart));
            b.action(this::cmd$disable);
            Method commandMethod = RegistrationUtil.getCommandMethod(MechanicCommands.class, (String)"disable", (Class[])new Class[]{Actor.class, MechanicType.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("reload", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Reload a mechanic's configuration"));
            b.parts((Collection)ImmutableList.of((Object)this.mechanicTypePart3));
            b.action(this::cmd$reload);
            Method commandMethod = RegistrationUtil.getCommandMethod(MechanicCommands.class, (String)"reload", (Class[])new Class[]{Actor.class, MechanicType.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("list", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"List mechanics"));
            b.parts((Collection)ImmutableList.of((Object)this.pagePart));
            b.action(this::cmd$list);
            Method commandMethod = RegistrationUtil.getCommandMethod(MechanicCommands.class, (String)"list", (Class[])new Class[]{Actor.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$enable(CommandParameters parameters) throws InvalidComponentException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(MechanicCommands.class, (String)"enable", (Class[])new Class[]{Actor.class, MechanicType.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.enable(this.extract$actor(parameters), this.extract$mechanicType(parameters), this.extract$listBoxPage(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$disable(CommandParameters parameters) throws InvalidComponentException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(MechanicCommands.class, (String)"disable", (Class[])new Class[]{Actor.class, MechanicType.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.disable(this.extract$actor(parameters), this.extract$mechanicType2(parameters), this.extract$listBoxPage(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$reload(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(MechanicCommands.class, (String)"reload", (Class[])new Class[]{Actor.class, MechanicType.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.reload(this.extract$actor(parameters), this.extract$mechanicType3(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$list(CommandParameters parameters) throws InvalidComponentException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(MechanicCommands.class, (String)"list", (Class[])new Class[]{Actor.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.list(this.extract$actor(parameters), this.extract$page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private MechanicType<?> extract$mechanicType(CommandParameters parameters) {
        return (MechanicType)this.mechanicTypePart.value(parameters).asSingle(mechanicType$__Key);
    }

    private int extract$listBoxPage(CommandParameters parameters) {
        return (Integer)this.listBoxPagePart.value(parameters).asSingle(integer_Key);
    }

    private MechanicType<?> extract$mechanicType2(CommandParameters parameters) {
        return (MechanicType)this.mechanicTypePart2.value(parameters).asSingle(mechanicType$__Key);
    }

    private MechanicType<?> extract$mechanicType3(CommandParameters parameters) {
        return (MechanicType)this.mechanicTypePart3.value(parameters).asSingle(mechanicType$__Key);
    }

    private int extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }
}

