/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic;

import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.util.formatting.component.InvalidComponentException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandsRegistration;
import org.enginehub.craftbook.mechanic.MechanicListBox;
import org.enginehub.craftbook.mechanic.MechanicManager;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.SubCommandPart;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class MechanicCommands {
    public static void register(CommandManagerService service, CommandManager commandManager, CommandRegistrationHandler registration) {
        commandManager.register("mechanic", builder -> {
            builder.aliases(List.of("mech", "mechs", "mechanics"));
            builder.description((Component)TextComponent.of((String)"Mechanic Commands"));
            CommandManager innerManager = service.newCommandManager();
            registration.register(innerManager, (CommandRegistration)MechanicCommandsRegistration.builder(), (Object)new MechanicCommands());
            builder.addPart((CommandPart)SubCommandPart.builder((TranslatableComponent)TranslatableComponent.of((String)"worldedit.argument.action"), (Component)TextComponent.of((String)"Sub-command to run.")).withCommands((Collection)innerManager.getAllCommands().collect(Collectors.toList())).required().build());
        });
    }

    @Command(name="enable", desc="Enable a mechanic")
    @CommandPermissions(value={"craftbook.mechanic.enable"})
    public void enable(Actor actor, @Arg(desc="The mechanic to enable") MechanicType<?> mechanicType, @ArgFlag(name=108, desc="Show the list box", def={"0"}) int listBoxPage) throws InvalidComponentException {
        try {
            CraftBook.getInstance().getPlatform().getMechanicManager().enableMechanic(mechanicType);
            CraftBook.getInstance().getPlatform().getConfiguration().enabledMechanics.add(mechanicType.id());
            CraftBook.getInstance().getPlatform().getConfiguration().save();
            CraftBook.getInstance().getPlatform().refreshPlayerCommandMaps();
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.mechanisms.enable-success", (Component[])new Component[]{TextComponent.of((String)mechanicType.getName(), (TextColor)TextColor.WHITE)}));
        }
        catch (MechanicInitializationException e) {
            actor.printError(e.getRichMessage());
        }
        if (listBoxPage > 0) {
            this.showListBox(actor, listBoxPage);
        }
    }

    @Command(name="disable", desc="Disable a mechanic")
    @CommandPermissions(value={"craftbook.mechanic.disable"})
    public void disable(Actor actor, @Arg(desc="The mechanic to disable") MechanicType<?> mechanicType, @ArgFlag(name=108, desc="Show the list box", def={"0"}) int listBoxPage) throws InvalidComponentException {
        Optional<?> mech = CraftBook.getInstance().getPlatform().getMechanicManager().getMechanic(mechanicType);
        if (mech.isPresent() && CraftBook.getInstance().getPlatform().getMechanicManager().disableMechanic((CraftBookMechanic)mech.get())) {
            CraftBook.getInstance().getPlatform().getConfiguration().enabledMechanics.remove(mechanicType.id());
            CraftBook.getInstance().getPlatform().getConfiguration().save();
            CraftBook.getInstance().getPlatform().refreshPlayerCommandMaps();
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.mechanisms.disable-success", (Component[])new Component[]{TextComponent.of((String)mechanicType.getName(), (TextColor)TextColor.WHITE)}));
        } else {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.not-enabled", (Component[])new Component[]{TextComponent.of((String)mechanicType.getName(), (TextColor)TextColor.WHITE)}));
        }
        if (listBoxPage > 0) {
            this.showListBox(actor, listBoxPage);
        }
    }

    @Command(name="reload", desc="Reload a mechanic's configuration")
    @CommandPermissions(value={"craftbook.mechanic.reload"})
    public void reload(Actor actor, @Arg(desc="The mechanic to reload") MechanicType<?> mechanicType) {
        try {
            MechanicManager mechanicManager = CraftBook.getInstance().getPlatform().getMechanicManager();
            Optional<?> mechanic = mechanicManager.getMechanic(mechanicType);
            if (mechanic.isEmpty()) {
                actor.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.not-enabled", (Component[])new Component[]{TextComponent.of((String)mechanicType.getName(), (TextColor)TextColor.WHITE)}));
                return;
            }
            mechanicManager.reloadMechanic((CraftBookMechanic)mechanic.get());
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.mechanisms.reload-success", (Component[])new Component[]{TextComponent.of((String)mechanicType.getName(), (TextColor)TextColor.WHITE)}));
        }
        catch (MechanicInitializationException e) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.reload-failed", (Component[])new Component[]{TextComponent.of((String)mechanicType.getName(), (TextColor)TextColor.WHITE), e.getRichMessage()}));
        }
    }

    @Command(name="list", desc="List mechanics")
    @CommandPermissions(value={"craftbook.mechanic.list"})
    public void list(Actor actor, @ArgFlag(name=112, desc="The page number", def={"1"}) int page) throws InvalidComponentException {
        this.showListBox(actor, page);
    }

    private void showListBox(Actor actor, int page) throws InvalidComponentException {
        MechanicListBox mechanicListBox = new MechanicListBox(actor);
        actor.print(mechanicListBox.create(page));
    }
}

