/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic;

import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.impl.CommandManagerImpl;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.SubCommandPart;

public class MechanicCommandRegistrar {
    private final CommandManagerService service;
    private final CommandManager topLevelCommandManager;
    private final CommandRegistrationHandler registration;
    private boolean dirty;

    public MechanicCommandRegistrar(CommandManagerService service, CommandManager topLevelCommandManager, CommandRegistrationHandler registration) {
        this.service = service;
        this.topLevelCommandManager = topLevelCommandManager;
        this.registration = registration;
    }

    private void markDirty() {
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void unmarkDirty() {
        this.dirty = false;
    }

    public void registerAsSubCommand(String command, Collection<String> aliases, String description, CommandManager parentManager, BiConsumer<CommandManager, CommandRegistrationHandler> op) {
        this.markDirty();
        parentManager.register(command, builder -> {
            builder.description((Component)TextComponent.of((String)description));
            builder.aliases(aliases);
            CommandManager manager = this.service.newCommandManager();
            op.accept(manager, this.registration);
            builder.addPart((CommandPart)SubCommandPart.builder((TranslatableComponent)TranslatableComponent.of((String)"worldedit.argument.action"), (Component)TextComponent.of((String)"Sub-command to run.")).withCommands(manager.getAllCommands().toList()).required().build());
        });
    }

    public void registerAsSubCommand(String command, String description, CommandManager parentManager, BiConsumer<CommandManager, CommandRegistrationHandler> op) {
        this.registerAsSubCommand(command, new ArrayList<String>(), description, parentManager, op);
    }

    public void registerTopLevelWithSubCommands(String command, Collection<String> aliases, String description, BiConsumer<CommandManager, CommandRegistrationHandler> op) {
        this.registerAsSubCommand(command, aliases, description, this.topLevelCommandManager, op);
    }

    public void registerTopLevelCommands(BiConsumer<CommandManager, CommandRegistrationHandler> op) {
        this.markDirty();
        CommandManager componentManager = this.service.newCommandManager();
        op.accept(componentManager, this.registration);
        this.topLevelCommandManager.registerManager(componentManager);
    }

    public void unregisterTopLevel(String command) {
        this.markDirty();
        try {
            Field field = CommandManagerImpl.class.getDeclaredField("commands");
            field.setAccessible(true);
            Map commandMap = (Map)field.get(this.topLevelCommandManager);
            commandMap.remove(command);
            field.set(this.topLevelCommandManager, commandMap);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            CraftBook.LOGGER.warn("Failed to unregister top-level command", (Throwable)e);
        }
    }
}

