/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.mechanic;

import com.sk89q.util.yaml.YAMLProcessor;
import java.nio.file.Path;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;

public interface CraftBookMechanic {
    public MechanicType<? extends CraftBookMechanic> getMechanicType();

    default public void enable() throws MechanicInitializationException {
    }

    default public void disable() {
    }

    default public void reload() throws MechanicInitializationException {
        this.disable();
        this.enable();
    }

    public void loadConfiguration(Path var1);

    default public void loadFromConfiguration(YAMLProcessor config) {
    }

    default public String getDocsUrl(MechanicType<? extends CraftBookMechanic> mechanicType) {
        return CraftBook.getDocsDomain() + "mechanics/" + mechanicType.id() + "/";
    }
}

