/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.commands;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.craftbook.commands.CraftBookCommands;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class CraftBookCommandsRegistration
implements CommandRegistration<CraftBookCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private CraftBookCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final NoArgCommandFlag loadedIcReportPart = CommandParts.flag((char)'i', (Component)TextComponent.of((String)"Include the loaded ICs Report.")).build();
    private final NoArgCommandFlag pastebinPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Submit the report to pastebin.")).build();

    private CraftBookCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static CraftBookCommandsRegistration builder() {
        return new CraftBookCommandsRegistration();
    }

    public CraftBookCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public CraftBookCommandsRegistration containerInstance(CraftBookCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public CraftBookCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public CraftBookCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("reload", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Reloads the CraftBook Common config"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$reload);
            Method commandMethod = RegistrationUtil.getCommandMethod(CraftBookCommands.class, (String)"reload", (Class[])new Class[]{Actor.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("version", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"ver"));
            b.description((Component)TextComponent.of((String)"Get CraftBook version."));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$version);
            Method commandMethod = RegistrationUtil.getCommandMethod(CraftBookCommands.class, (String)"version", (Class[])new Class[]{Actor.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("report", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Writes a report on CraftBook"));
            b.parts((Collection)ImmutableList.of((Object)this.loadedIcReportPart, (Object)this.pastebinPart));
            b.action(this::cmd$report);
            Method commandMethod = RegistrationUtil.getCommandMethod(CraftBookCommands.class, (String)"report", (Class[])new Class[]{Actor.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$reload(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(CraftBookCommands.class, (String)"reload", (Class[])new Class[]{Actor.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.reload(this.extract$actor(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$version(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(CraftBookCommands.class, (String)"version", (Class[])new Class[]{Actor.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.version(this.extract$actor(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$report(CommandParameters parameters) throws CraftBookException, AuthorizationException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(CraftBookCommands.class, (String)"report", (Class[])new Class[]{Actor.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.report(this.extract$actor(parameters), this.extract$loadedIcReport(parameters), this.extract$pastebin(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private boolean extract$loadedIcReport(CommandParameters parameters) {
        return this.loadedIcReportPart.in(parameters);
    }

    private boolean extract$pastebin(CommandParameters parameters) {
        return this.pastebinPart.in(parameters);
    }
}

