/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.commands;

import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import com.sk89q.worldedit.util.paste.ActorCallbackPaste;
import com.sk89q.worldedit.util.report.Report;
import com.sk89q.worldedit.util.report.ReportList;
import com.sk89q.worldedit.util.report.SystemInfoReport;
import com.sk89q.worldedit.util.task.Supervisor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.commands.CraftBookCommandsRegistration;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.craftbook.mechanic.MechanicCommands;
import org.enginehub.craftbook.util.report.GlobalConfigReport;
import org.enginehub.craftbook.util.report.ReportFlag;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.part.CommandPart;
import org.enginehub.piston.part.SubCommandPart;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class CraftBookCommands {
    public static void register(CommandManagerService service, CommandManager commandManager, CommandRegistrationHandler registration) {
        commandManager.register("craftbook", builder -> {
            builder.aliases(List.of("cb"));
            builder.description((Component)TextComponent.of((String)"CraftBook Commands"));
            CommandManager manager = service.newCommandManager();
            registration.register(manager, (CommandRegistration)CraftBookCommandsRegistration.builder(), (Object)new CraftBookCommands());
            MechanicCommands.register(service, manager, registration);
            builder.addPart((CommandPart)SubCommandPart.builder((TranslatableComponent)TranslatableComponent.of((String)"worldedit.argument.action"), (Component)TextComponent.of((String)"Sub-command to run.")).withCommands((Collection)manager.getAllCommands().collect(Collectors.toList())).required().build());
        });
    }

    @Command(name="reload", desc="Reloads the CraftBook Common config")
    @CommandPermissions(value={"craftbook.reload"})
    public void reload(Actor actor) {
        try {
            CraftBook.getInstance().getPlatform().reloadConfiguration();
        }
        catch (Throwable e) {
            CraftBook.LOGGER.error((Object)e);
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.reload.failed"));
            return;
        }
        actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.reload.reloaded"));
    }

    @Command(name="version", aliases={"ver"}, desc="Get CraftBook version.")
    @CommandPermissions(value={"craftbook.version"})
    public void version(Actor actor) {
        actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.version.version", (Component[])new Component[]{TextComponent.of((String)CraftBook.getInstance().getPlatform().getPlatformName())}));
        actor.printInfo(TextComponent.of((String)"https://github.com/EngineHub/CraftBook/").clickEvent(ClickEvent.openUrl((String)"https://github.com/EngineHub/CraftBook/")));
    }

    @Command(name="report", desc="Writes a report on CraftBook")
    @CommandPermissions(value={"craftbook.report"})
    public void report(Actor actor, @Switch(name=105, desc="Include the loaded ICs Report.") boolean loadedIcReport, @Switch(name=112, desc="Submit the report to pastebin.") boolean pastebin) throws CraftBookException, AuthorizationException {
        ReportList report = new ReportList("Report");
        EnumSet<ReportFlag> reportFlags = EnumSet.noneOf(ReportFlag.class);
        if (loadedIcReport) {
            reportFlags.add(ReportFlag.IC_REPORT);
        }
        report.add((Report)new SystemInfoReport());
        report.add((Report)new GlobalConfigReport());
        CraftBook.getInstance().getPlatform().addPlatformReports(report, reportFlags.toArray(new ReportFlag[0]));
        String result = report.toString();
        try {
            Path dest = CraftBook.getInstance().getPlatform().getWorkingDirectory().resolve("report.txt");
            Files.writeString(dest, (CharSequence)result, StandardCharsets.UTF_8, new OpenOption[0]);
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.report.written", (Component[])new Component[]{TextComponent.of((String)dest.toAbsolutePath().toString())}));
        }
        catch (IOException e) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.report.error", (Component[])new Component[]{TextComponent.of((String)e.getMessage())}));
            return;
        }
        if (pastebin) {
            if (!actor.hasPermission("craftbook.report.pastebin")) {
                throw new AuthorizationException();
            }
            ActorCallbackPaste.pastebin((Supervisor)CraftBook.getInstance().getSupervisor(), (Actor)actor, (String)result, (TranslatableComponent.Builder)TranslatableComponent.builder((String)"craftbook.report.success"));
        }
    }
}

