/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.command.argument;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.sk89q.worldedit.command.util.SuggestionHelper;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.Registry;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.lang.reflect.Field;
import java.util.List;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.converter.ArgumentConverter;
import org.enginehub.piston.converter.ConversionResult;
import org.enginehub.piston.converter.FailedConversion;
import org.enginehub.piston.converter.SuccessfulConversion;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;

public final class RegistryConverter<V extends Keyed>
implements ArgumentConverter<V> {
    private final Registry<V> registry;
    private final TextComponent choices;

    public static void register(CommandManager commandManager) {
        ImmutableMap.of((Object)new TypeToken<MechanicType<?>>(){}, MechanicType.class).forEach((key, value) -> commandManager.registerConverter(Key.of((TypeToken)key), RegistryConverter.from(value)));
    }

    private static <V extends Keyed> RegistryConverter<V> from(Class<Keyed> registryType) {
        try {
            Field registryField = registryType.getDeclaredField("REGISTRY");
            Registry registry = (Registry)registryField.get(null);
            return new RegistryConverter<V>(registry);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Not a registry-backed type: " + registryType.getName());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Registry field inaccessible on " + registryType.getName());
        }
    }

    private RegistryConverter(Registry<V> registry) {
        this.registry = registry;
        this.choices = TextComponent.of((String)("any " + registry.getName()));
    }

    public Component describeAcceptableArguments() {
        return this.choices;
    }

    public ConversionResult<V> convert(String argument, InjectedValueAccess injectedValueAccess) {
        Keyed result = this.registry.get(argument);
        return result == null ? FailedConversion.from((Throwable)new IllegalArgumentException("Not a valid " + this.registry.getName() + ": " + argument)) : SuccessfulConversion.fromSingle((Object)result);
    }

    public List<String> getSuggestions(String input, InjectedValueAccess context) {
        return SuggestionHelper.getRegistrySuggestions(this.registry, (String)input).toList();
    }
}

