/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.st;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SelfTriggerPingEvent;
import org.enginehub.craftbook.bukkit.events.SelfTriggerThinkEvent;
import org.enginehub.craftbook.bukkit.events.SelfTriggerUnregisterEvent;
import org.enginehub.craftbook.st.MechanicClock;
import org.enginehub.craftbook.st.SelfTriggerManager;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.jspecify.annotations.Nullable;

public class BukkitSelfTriggerManager
implements SelfTriggerManager,
Listener {
    private final MechanicClock mechanicClock = new MechanicClock();
    private final Set<Location> thinkingMechanics = new HashSet<Location>();
    private final List<Location> removingLocations = new ArrayList<Location>();
    private @Nullable BukkitTask clockTask;

    @Override
    public void setup() {
        CraftBook.LOGGER.info("Enumerating chunks for self-triggered components...");
        long start = System.currentTimeMillis();
        int numChunks = 0;
        for (World world : Bukkit.getWorlds()) {
            Chunk[] chunks;
            for (Chunk chunk : chunks = world.getLoadedChunks()) {
                this.registerSelfTrigger(chunk);
            }
            numChunks += chunks.length;
        }
        CraftBook.LOGGER.info(numChunks + " chunk(s) for " + Bukkit.getWorlds().size() + " world(s) processed (" + (System.currentTimeMillis() - start) + "ms elapsed)");
        this.clockTask = Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), (Runnable)this.mechanicClock, 0L, (long)CraftBook.getInstance().getPlatform().getConfiguration().stThinkRate);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)CraftBookPlugin.inst());
    }

    @Override
    public void shutdown() {
        HandlerList.unregisterAll((Listener)this);
        if (this.clockTask != null) {
            this.clockTask.cancel();
            this.clockTask = null;
        }
        for (Location location : this.removingLocations) {
            this.thinkingMechanics.remove(location);
        }
        for (Location location : this.thinkingMechanics) {
            this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.UNLOAD);
        }
        this.thinkingMechanics.clear();
        this.removingLocations.clear();
    }

    @Override
    public void think() {
        if (Bukkit.getServer().isPaused()) {
            return;
        }
        for (Location location : this.removingLocations) {
            this.thinkingMechanics.remove(location);
        }
        this.removingLocations.clear();
        for (Location location : this.thinkingMechanics) {
            if (!location.getWorld().isChunkLoaded(location.getBlockX() >> 4, location.getBlockZ() >> 4)) {
                this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.UNLOAD);
                continue;
            }
            try {
                SelfTriggerThinkEvent event = new SelfTriggerThinkEvent(location.getBlock());
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (event.isHandled()) continue;
                this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.NOT_HANDLED);
            }
            catch (Throwable t) {
                CraftBook.LOGGER.warn("CraftBook mechanic: Failed to think for " + String.valueOf(location), t);
                this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.ERROR);
            }
        }
    }

    private void registerSelfTrigger(Chunk chunk) {
        try {
            for (BlockState state : chunk.getTileEntities(SignUtil::isSign, false)) {
                if (!(state instanceof Sign) || this.thinkingMechanics.contains(state.getLocation())) continue;
                SelfTriggerPingEvent event = new SelfTriggerPingEvent(state.getBlock());
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
                if (!event.isHandled()) continue;
                this.registerSelfTrigger(state.getLocation());
            }
        }
        catch (Throwable e) {
            CraftBook.LOGGER.warn("A corrupt tile entity was found in the chunk: (world: " + chunk.getWorld().getName() + " x: " + chunk.getX() + " z: " + chunk.getZ() + ") Self-Triggering mechanics may not work here until the issue is resolved.", e);
        }
    }

    public void registerSelfTrigger(Location location) {
        if (this.thinkingMechanics.contains(location)) {
            return;
        }
        this.thinkingMechanics.add(location);
    }

    public void unregisterSelfTrigger(Location location, SelfTriggerUnregisterEvent.UnregisterReason reason) {
        if (!this.thinkingMechanics.contains(location)) {
            return;
        }
        SelfTriggerUnregisterEvent event = new SelfTriggerUnregisterEvent(location.getBlock(), reason);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.removingLocations.add(location);
            CraftBookPlugin.logDebugMessage("Unregistered ST at: " + String.valueOf(location) + " for reason: " + reason.name(), "st.unregister");
        }
    }

    public List<Location> getSelfTriggeringMechanics() {
        return List.copyOf(this.thinkingMechanics);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.registerSelfTrigger(event.getChunk());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        long chunkKey = event.getChunk().getChunkKey();
        for (Location location : this.thinkingMechanics) {
            if (Chunk.getChunkKey((Location)location) != chunkKey) continue;
            this.unregisterSelfTrigger(location, SelfTriggerUnregisterEvent.UnregisterReason.UNLOAD);
        }
    }
}

