/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.variables;

import com.google.common.base.Preconditions;
import com.sk89q.util.yaml.YAMLFormat;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.enginehub.craftbook.ChangedSign;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.MechanicTypes;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanics.ic.IC;
import org.enginehub.craftbook.mechanics.ic.ICManager;
import org.enginehub.craftbook.mechanics.variables.VariableCommands;
import org.enginehub.craftbook.mechanics.variables.VariableConfiguration;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.jspecify.annotations.Nullable;

public class BukkitVariableManager
extends VariableManager
implements Listener {
    private VariableConfiguration variableConfiguration;

    public BukkitVariableManager(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() throws MechanicInitializationException {
        instance = this;
        CraftBookPlugin.logDebugMessage("Initializing Variables!", "startup.variables");
        try {
            Path varFile = CraftBook.getInstance().getPlatform().getWorkingDirectory().resolve("variables.yml");
            if (!Files.exists(varFile, new LinkOption[0])) {
                Files.createFile(varFile, new FileAttribute[0]);
            }
            this.variableConfiguration = new VariableConfiguration(new YAMLProcessor(varFile, true, YAMLFormat.EXTENDED));
            this.variableConfiguration.load();
        }
        catch (Exception e) {
            throw new MechanicInitializationException(MechanicTypes.VARIABLES.get(), (Component)TranslatableComponent.of((String)"craftbook.variables.failed-to-load"), e);
        }
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.registerTopLevelWithSubCommands("variables", List.of("var", "variable", "vars"), "CraftBook Variable Commands", VariableCommands::register);
    }

    @Override
    public void disable() {
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.unregisterTopLevel("variables");
        registrar.unregisterTopLevel("var");
        registrar.unregisterTopLevel("variable");
        registrar.unregisterTopLevel("vars");
        if (this.variableConfiguration != null) {
            this.variableConfiguration.save();
            this.variableConfiguration = null;
        }
        this.variableStore.clear();
        instance = null;
    }

    @Override
    public void updateForVariableChange(VariableKey key) {
        this.resetICCache(key);
    }

    private boolean signHasVariable(VariableKey variableKey, ChangedSign sign) {
        for (net.kyori.adventure.text.Component comp : sign.getLines()) {
            String line = PlainTextComponentSerializer.plainText().serialize(comp);
            if (line.contains("%" + String.valueOf(variableKey) + "%")) {
                return true;
            }
            if (!variableKey.getNamespace().equals("global") && !variableKey.getNamespace().contains("-") || !line.contains("%" + variableKey.getVariable() + "%")) continue;
            return true;
        }
        return false;
    }

    private void resetICCache(VariableKey variableKey) {
        if (ICManager.inst() != null) {
            ICManager.getCachedICs().entrySet().removeIf(ic -> this.signHasVariable(variableKey, ((IC)ic.getValue()).getSign()));
        }
    }

    @Override
    public net.kyori.adventure.text.Component renderVariables(net.kyori.adventure.text.Component line, @Nullable Actor actor) {
        Preconditions.checkNotNull((Object)line);
        for (VariableKey possibleVariable : this.getPossibleVariables(line, actor)) {
            CraftBookPlugin.logDebugMessage("Possible variable: (" + possibleVariable.toString() + ") detected!", "variables.line-parsing");
            if (actor != null && !possibleVariable.hasPermission(actor, "use")) continue;
            CraftBookPlugin.logDebugMessage(String.valueOf(possibleVariable) + " permissions granted!", "variables.line-parsing");
            String value = instance.getVariable(possibleVariable);
            if (value == null) continue;
            TextReplacementConfig config = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%" + possibleVariable.getOriginalForm() + "%").replacement(value).build();
            line = line.replaceText(config);
        }
        TextReplacementConfig config = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("\\%").replacement("%").build();
        return line.replaceText(config);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerChat(AsyncChatEvent event) {
        if (this.playerChatOverride && event.getPlayer().hasPermission("craftbook.variables.chat")) {
            event.message(this.renderVariables(event.message(), (Actor)CraftBookPlugin.inst().wrapPlayer(event.getPlayer())));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        if (this.playerCommandOverride && event.getPlayer().hasPermission("craftbook.variables.commands")) {
            event.setMessage(this.renderVariables(event.getMessage(), (Actor)CraftBookPlugin.inst().wrapPlayer(event.getPlayer())));
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onConsoleCommandPreprocess(ServerCommandEvent event) {
        if (this.consoleOverride) {
            event.setCommand(this.renderVariables(event.getCommand(), null));
        }
    }
}

