/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.signcopier;

import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.signcopier.SignCopier;
import org.enginehub.craftbook.mechanics.signcopier.SignEditCommands;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;

public class BukkitSignCopier
extends SignCopier
implements Listener {
    public BukkitSignCopier(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.registerTopLevelWithSubCommands("signedit", List.of("edsign", "signcopy"), "CraftBook SignCopier Commands", (commandManager, registration) -> SignEditCommands.register(commandManager, registration, this));
    }

    @Override
    public void disable() {
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.unregisterTopLevel("signedit");
        registrar.unregisterTopLevel("edsign");
        registrar.unregisterTopLevel("signcopy");
        this.signs.clear();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onRightClick(SignClickEvent event) {
        Block block = event.getClickedBlock();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.LEFT_CLICK_BLOCK || event.getHand() == null || block == null) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = event.getWrappedPlayer();
        BaseItemStack heldItem = player.getItemInHand(event.getHand() == EquipmentSlot.HAND ? HandSide.MAIN_HAND : HandSide.OFF_HAND);
        if (heldItem.getType() != this.item) {
            return;
        }
        if (!player.hasPermission("craftbook.signcopier.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canBreak(event.getPlayer(), block)) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Sign sign = event.getSign().getSign();
            Side side = event.getSide();
            this.signs.put(player.getUniqueId(), BukkitSignCopier.createSignDataFromSign(sign.getSide(side)));
            player.printInfo((Component)TranslatableComponent.of((String)"craftbook.signcopier.copy"));
            event.setCancelled(true);
        } else if (event.getAction().equals((Object)Action.LEFT_CLICK_BLOCK) && this.signs.containsKey(player.getUniqueId())) {
            Sign sign = event.getSign().getSign();
            Side side = event.getSide();
            SignSide signSide = sign.getSide(side);
            SignCopier.SignData signData = (SignCopier.SignData)this.signs.get(player.getUniqueId());
            SignChangeEvent sev = new SignChangeEvent(block, event.getPlayer(), signData.lines(), side);
            Bukkit.getPluginManager().callEvent((Event)sev);
            if (!sev.isCancelled() || !CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections) {
                List outputLines = sev.lines();
                for (int i = 0; i < outputLines.size(); ++i) {
                    signSide.line(i, (net.kyori.adventure.text.Component)outputLines.get(i));
                }
                if (this.copyColor && signData.color() != null) {
                    signSide.setColor((DyeColor)signData.color());
                }
                if (this.copyGlowing) {
                    signSide.setGlowingText(signData.glowing());
                }
                sign.update();
                player.printInfo((Component)TranslatableComponent.of((String)"craftbook.signcopier.paste"));
            } else {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.signcopier.denied"));
            }
            event.setCancelled(true);
        }
    }

    public static SignCopier.SignData<DyeColor> createSignDataFromSign(SignSide sign) {
        return new SignCopier.SignData<DyeColor>(sign.lines(), sign.isGlowingText(), sign.getColor());
    }
}

