/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.piston;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import io.papermc.paper.entity.TeleportFlag;
import java.util.Collection;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.block.data.type.Piston;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.piston.BetterPistons;
import org.enginehub.craftbook.mechanics.piston.PistonType;
import org.enginehub.craftbook.util.EntityUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class BukkitBetterPistons
extends BetterPistons
implements Listener {
    public BukkitBetterPistons(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Block pistonBlock = SignUtil.findNonSignBackBlock(event.getBlock());
        BlockType pistonBlockType = BukkitAdapter.asBlockType((Material)pistonBlock.getType());
        if (pistonBlockType == BlockTypes.PISTON || pistonBlockType == BlockTypes.STICKY_PISTON) {
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
            Enum type = null;
            String line1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
            for (PistonType testType : PistonType.values()) {
                if (!this.isEnabled(testType) || !line1.equalsIgnoreCase(testType.getSignText())) continue;
                event.line(1, (Component)Component.text((String)testType.getSignText()));
                type = testType;
                break;
            }
            if (type == null) {
                return;
            }
            if (type == PistonType.BOUNCE) {
                double velocity = 1.0;
                try {
                    velocity = Double.parseDouble(event.getLine(2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                velocity = Math.min(Math.max(velocity, -this.maxBounceVelocity), this.maxBounceVelocity);
                event.line(2, (Component)Component.text((double)velocity));
            }
            if (!player.hasPermission("craftbook.betterpistons." + type.name().toLowerCase(Locale.ENGLISH) + ".create")) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                }
                SignUtil.cancelSignChange(event);
                return;
            }
            if (!((PistonType)type).getAllowedBlocks().contains(pistonBlockType)) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.betterpistons.invalid-piston-block"));
                SignUtil.cancelSignChange(event);
                return;
            }
            if (ProtectionUtil.shouldUseProtection()) {
                Piston pistonData = (Piston)pistonBlock.getBlockData();
                if (type == PistonType.BOUNCE || type == PistonType.CRUSH) {
                    Block off = pistonBlock.getRelative(pistonData.getFacing());
                    if (!ProtectionUtil.canBreak(event.getPlayer(), off)) {
                        if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                        }
                        SignUtil.cancelSignChange(event);
                        return;
                    }
                } else if (type == PistonType.SUPER_PUSH || type == PistonType.SUPER_STICKY) {
                    int distance = 10;
                    try {
                        distance = Integer.parseInt(RegexUtil.MINUS_PATTERN.split(event.getLine(2))[0]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    distance = Math.min(this.maxDistance, distance);
                    Block off = pistonBlock;
                    for (int i = 0; i < distance; ++i) {
                        off = off.getRelative(pistonData.getFacing());
                        if (ProtectionUtil.canBreak(event.getPlayer(), off)) continue;
                        if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                        }
                        SignUtil.cancelSignChange(event);
                        return;
                    }
                }
            }
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)("craftbook.betterpistons." + type.name().toLowerCase(Locale.ENGLISH) + ".created")));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Piston piston = (Piston)event.getBlock().getBlockData();
        for (BlockFace face : LocationUtil.getDirectFaces()) {
            if (face == piston.getFacing() || !SignUtil.isSign(event.getBlock().getRelative(face))) continue;
            BlockFace facing = SignUtil.getBack(event.getBlock().getRelative(face));
            if (face != BlockFace.UP && face != BlockFace.DOWN && !SignUtil.getBackBlock(event.getBlock().getRelative(face)).equals((Object)event.getBlock())) continue;
            Block sign = event.getBlock();
            do {
                sign = sign.getRelative(face);
                Sign bukkitSign = (Sign)sign.getState(false);
                block7: for (Side side : Side.values()) {
                    PistonType type = PistonType.getFromSign(bukkitSign.getSide(side).getLine(1));
                    if (type == null) continue;
                    BukkitChangedSign signState = BukkitChangedSign.create(bukkitSign, side);
                    switch (type) {
                        case CRUSH: {
                            this.crush(event.getBlock(), piston);
                            continue block7;
                        }
                        case BOUNCE: {
                            this.bounce(event.getBlock(), piston, signState);
                            continue block7;
                        }
                        case SUPER_PUSH: {
                            this.superPush(event.getBlock(), piston, signState);
                            continue block7;
                        }
                    }
                }
            } while (SignUtil.isSign(sign.getRelative(face)) && SignUtil.getBack(sign) == facing);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.isSticky()) {
            return;
        }
        for (BlockFace face : LocationUtil.getDirectFaces()) {
            if (face == event.getDirection() || !SignUtil.isSign(event.getBlock().getRelative(face))) continue;
            BlockFace facing = SignUtil.getBack(event.getBlock().getRelative(face));
            if (face != BlockFace.UP && face != BlockFace.DOWN && !SignUtil.getBackBlock(event.getBlock().getRelative(face)).equals((Object)event.getBlock())) continue;
            Block sign = event.getBlock();
            block1: do {
                sign = sign.getRelative(face);
                Sign bukkitSign = (Sign)sign.getState(false);
                for (Side side : Side.values()) {
                    PistonType type = PistonType.getFromSign(bukkitSign.getSide(side).getLine(1));
                    if (type != PistonType.SUPER_STICKY) continue;
                    this.superSticky(event.getBlock(), event.getDirection(), BukkitChangedSign.create(bukkitSign, side));
                    continue block1;
                }
            } while (SignUtil.isSign(sign.getRelative(face)) && SignUtil.getBack(sign) == facing);
        }
    }

    public void crush(Block trigger, Piston piston) {
        Block pistonHead = trigger.getRelative(piston.getFacing());
        if (this.crushInstaKill) {
            BoundingBox box = BoundingBox.of((Block)pistonHead);
            for (Entity ent : trigger.getWorld().getNearbyEntities(box)) {
                EntityUtil.killEntity(ent);
            }
        }
        if (Blocks.containsFuzzy((Collection)this.crushBlockBlacklist, (BlockStateHolder)BukkitAdapter.adapt((BlockData)pistonHead.getBlockData()))) {
            return;
        }
        pistonHead.breakNaturally();
        pistonHead.setType(Material.AIR, false);
    }

    public void bounce(Block trigger, Piston piston, BukkitChangedSign signState) {
        double multiplier;
        if (piston.getMaterial() == Material.STICKY_PISTON) {
            return;
        }
        try {
            String line2 = PlainTextComponentSerializer.plainText().serialize(signState.getLine(2));
            multiplier = Double.parseDouble(line2);
        }
        catch (Exception ignored) {
            multiplier = 1.0;
            signState.setLine(2, (Component)Component.text((String)"1.0"));
            signState.update(false);
        }
        multiplier = Math.min(Math.max(multiplier, -this.maxBounceVelocity), this.maxBounceVelocity);
        Vector vel = new Vector(piston.getFacing().getModX(), piston.getFacing().getModY(), piston.getFacing().getModZ()).multiply(multiplier);
        Block pistonHead = trigger.getRelative(piston.getFacing());
        BlockData pistonHeadData = pistonHead.getBlockData();
        Material pistonHeadType = pistonHeadData.getMaterial();
        if (pistonHeadType.isAir() || pistonHeadType == Material.MOVING_PISTON || pistonHeadType == Material.PISTON_HEAD || InventoryUtil.doesBlockHaveInventory(pistonHead) || Blocks.containsFuzzy((Collection)this.bounceBlockBlacklist, (BlockStateHolder)BukkitAdapter.adapt((BlockData)pistonHeadData))) {
            for (Entity ent : trigger.getWorld().getNearbyEntities(BoundingBox.of((Block)pistonHead))) {
                ent.setVelocity(ent.getVelocity().add(vel));
            }
        } else {
            FallingBlock fall = (FallingBlock)trigger.getWorld().spawn(pistonHead.getLocation().add(vel), FallingBlock.class, fallingBlock -> fallingBlock.setBlockData(pistonHeadData));
            pistonHead.setType(Material.AIR);
            fall.setVelocity(vel);
        }
    }

    public void superSticky(Block trigger, BlockFace facing, BukkitChangedSign signState) {
        Block pistonHead = trigger.getRelative(facing);
        Material pistonHeadType = pistonHead.getType();
        if (pistonHeadType == Material.PISTON_HEAD || pistonHeadType == Material.MOVING_PISTON) {
            int block = 10;
            int amount = 1;
            try {
                String line2 = PlainTextComponentSerializer.plainText().serialize(signState.getLine(2));
                String[] split = RegexUtil.COLON_PATTERN.split(line2);
                block = Integer.parseInt(split[0]);
                if (split.length > 1) {
                    amount = Integer.parseInt(split[1]);
                }
            }
            catch (Exception ignored) {
                signState.setLine(2, (Component)Component.text((String)(Math.min(this.maxDistance, 10) + ":1")));
                signState.update(false);
            }
            block = Math.min(this.maxDistance, block);
            String line3 = PlainTextComponentSerializer.plainText().serialize(signState.getLine(3));
            boolean air = line3.equalsIgnoreCase("AIR");
            int fblock = block;
            for (int run = 0; run < amount; ++run) {
                Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                    for (int x = 3; x <= fblock + 2; ++x) {
                        Block to = trigger.getRelative(facing, x - 1);
                        Block from = trigger.getRelative(facing, x);
                        Material fromType = from.getType();
                        if (x >= fblock + 2 || fromType.isAir() && !air || fromType == Material.MOVING_PISTON || fromType == Material.PISTON_HEAD || this.isImmovableBlock(from)) {
                            to.setType(Material.AIR);
                            break;
                        }
                        if (!to.getType().isAir()) continue;
                        BoundingBox fromBounds = BoundingBox.of((Block)from);
                        for (Entity ent : trigger.getWorld().getNearbyEntities(fromBounds)) {
                            Location dest = ent.getLocation().subtract(facing.getDirection());
                            if (ent instanceof Player) {
                                Player player = (Player)ent;
                                player.teleport(dest, PlayerTeleportEvent.TeleportCause.PLUGIN, new TeleportFlag[]{TeleportFlag.Relative.VELOCITY_X, TeleportFlag.Relative.VELOCITY_Y, TeleportFlag.Relative.VELOCITY_Z, TeleportFlag.Relative.VELOCITY_ROTATION});
                                continue;
                            }
                            ent.teleport(dest);
                        }
                        if (!BukkitBetterPistons.copyData(from, to)) continue;
                        from.setType(Material.AIR);
                    }
                }, 3L * (long)(run + 1));
            }
        }
    }

    public void superPush(Block trigger, Piston piston, BukkitChangedSign signState) {
        Block pistonHead = trigger.getRelative(piston.getFacing());
        Material pistonHeadType = pistonHead.getType();
        if (pistonHeadType != Material.PISTON_HEAD && pistonHeadType != Material.MOVING_PISTON) {
            int block = 10;
            int amount = 1;
            try {
                String line2 = PlainTextComponentSerializer.plainText().serialize(signState.getLine(2));
                String[] split = RegexUtil.COLON_PATTERN.split(line2);
                block = Integer.parseInt(split[0]);
                if (split.length > 1) {
                    amount = Integer.parseInt(split[1]);
                }
            }
            catch (Exception ignored) {
                signState.setLine(2, (Component)Component.text((String)(Math.min(this.maxDistance, 10) + ":1")));
                signState.update(false);
            }
            int blockCount = block = Math.min(this.maxDistance, block);
            for (int run = 0; run < amount; ++run) {
                Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                    for (int x = blockCount + 2; x >= 1; --x) {
                        Block from = trigger.getRelative(piston.getFacing(), x);
                        Block to = trigger.getRelative(piston.getFacing(), x + 1);
                        Material fromType = from.getType();
                        if (fromType == Material.MOVING_PISTON || fromType == Material.PISTON_HEAD || this.isImmovableBlock(from) || !to.getType().isAir()) continue;
                        BoundingBox fromBounds = BoundingBox.of((Block)from);
                        for (Entity ent : trigger.getWorld().getNearbyEntities(fromBounds)) {
                            Location dest = ent.getLocation().add(piston.getFacing().getDirection());
                            if (ent instanceof Player) {
                                Player player = (Player)ent;
                                player.teleport(dest, PlayerTeleportEvent.TeleportCause.PLUGIN, new TeleportFlag[]{TeleportFlag.Relative.VELOCITY_X, TeleportFlag.Relative.VELOCITY_Y, TeleportFlag.Relative.VELOCITY_Z, TeleportFlag.Relative.VELOCITY_ROTATION});
                                continue;
                            }
                            ent.teleport(dest);
                        }
                        if (!BukkitBetterPistons.copyData(from, to)) continue;
                        from.setType(Material.AIR);
                    }
                }, 3L * (long)run);
            }
        }
    }

    public static boolean copyData(Block from, Block to) {
        World world = BukkitAdapter.adapt((org.bukkit.World)from.getWorld());
        BaseBlock fromBlock = world.getFullBlock(BlockVector3.at((int)from.getX(), (int)from.getY(), (int)from.getZ()));
        try {
            return world.setBlock(BlockVector3.at((int)to.getX(), (int)to.getY(), (int)to.getZ()), (BlockStateHolder)fromBlock, SideEffectSet.defaults().with(SideEffect.VALIDATION, SideEffect.State.ON));
        }
        catch (WorldEditException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean isImmovableBlock(Block block) {
        Chest chest;
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Chest && (chest = (Chest)blockData).getType() != Chest.Type.SINGLE) {
            return true;
        }
        if (Blocks.containsFuzzy((Collection)this.movementBlacklist, (BlockStateHolder)BukkitAdapter.adapt((BlockData)blockData))) {
            return true;
        }
        return blockData.getMaterial() == Material.MOVING_PISTON;
    }
}

