/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.minecart;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.item.ItemType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.TemporaryCart;
import org.enginehub.craftbook.util.CartUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.RailUtil;

public class BukkitTemporaryCart
extends TemporaryCart
implements Listener {
    private final NamespacedKey temporaryCartKey = new NamespacedKey("craftbook", "temporary_cart");

    public BukkitTemporaryCart(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    public NamespacedKey getTemporaryCartKey() {
        return this.temporaryCartKey;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        BlockType clickedBlockType = BukkitAdapter.asBlockType((Material)event.getClickedBlock().getType());
        if (!RailUtil.isTrack(clickedBlockType)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (player.isHoldingBlock() || player.isInsideVehicle() || player.isSneaking()) {
            return;
        }
        if (CartUtil.isMinecart(BukkitAdapter.adapt((ItemType)player.getItemInHand(HandSide.MAIN_HAND).getType()))) {
            return;
        }
        if (!player.hasPermission("craftbook.temporarycart.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        RideableMinecart cart = (RideableMinecart)event.getClickedBlock().getWorld().spawn(event.getClickedBlock().getLocation().toCenterLocation(), RideableMinecart.class);
        cart.getPersistentDataContainer().set(this.temporaryCartKey, PersistentDataType.BYTE, (Object)1);
        cart.addPassenger((Entity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerDismount(VehicleExitEvent event) {
        if (!(event.getVehicle() instanceof RideableMinecart)) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle.getPersistentDataContainer().has(this.temporaryCartKey, PersistentDataType.BYTE)) {
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> ((Vehicle)vehicle).remove(), 2L);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        if (!(event.getVehicle() instanceof RideableMinecart)) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle.getPersistentDataContainer().has(this.temporaryCartKey, PersistentDataType.BYTE)) {
            event.setCancelled(true);
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> ((Vehicle)vehicle).remove(), 2L);
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (Entity entity : event.getChunk().getEntities()) {
            if (!entity.getPersistentDataContainer().has(this.temporaryCartKey, PersistentDataType.BYTE)) continue;
            entity.remove();
        }
    }
}

