/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.minecart;

import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.MoreRails;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitMoreRails
extends MoreRails
implements Listener {
    public BukkitMoreRails(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)vehicle;
        Block toBlock = event.getTo().getBlock();
        Material toType = toBlock.getType();
        if (this.pressurePlate && Tag.PRESSURE_PLATES.isTagged((Keyed)toType)) {
            minecart.setVelocity(minecart.getVelocity().normalize());
        } else if (this.ladder) {
            double maxSpeed = minecart.getMaxSpeed();
            Vector velocity = new Vector(0.0, this.ladderVerticalVelocity, 0.0);
            if (velocity.lengthSquared() > maxSpeed * maxSpeed) {
                double length = velocity.length() / maxSpeed;
                velocity.setX(velocity.getX() / length);
                velocity.setY(velocity.getY() / length);
                velocity.setZ(velocity.getZ() / length);
            }
            BlockFace face = null;
            if (toType == Material.LADDER) {
                face = ((Directional)toBlock.getBlockData()).getFacing().getOppositeFace();
            } else if (toType == Material.VINE) {
                MultipleFacing vine = (MultipleFacing)toBlock.getBlockData();
                for (BlockFace test : vine.getAllowedFaces()) {
                    if (!vine.hasFace(test)) continue;
                    face = test;
                    break;
                }
            }
            if (face != null) {
                velocity.add(new Vector(face.getModX(), 0, face.getModZ()));
                minecart.setVelocity(minecart.getVelocity().add(velocity));
            }
        }
    }
}

