/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.minecart;

import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.MinecartPhysicsControl;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitMinecartPhysicsControl
extends MinecartPhysicsControl
implements Listener {
    private Vector fallSpeed;
    private Vector derailedVelocityMod;

    public BukkitMinecartPhysicsControl(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        this.fallSpeed = new Vector(this.horizontalFallSpeed, this.verticalFallSpeed, this.horizontalFallSpeed);
        this.derailedVelocityMod = new Vector(this.offRailSpeed, this.offRailSpeed, this.offRailSpeed);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleCreate(VehicleCreateEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        Minecart cart = (Minecart)vehicle;
        cart.setSlowWhenEmpty(this.slowWhenEmpty);
        if (this.verticalFallSpeed != -1.0 && this.horizontalFallSpeed != -1.0) {
            cart.setFlyingVelocityMod(this.fallSpeed);
        }
        if (this.offRailSpeed != -1.0) {
            cart.setDerailedVelocityMod(this.derailedVelocityMod);
        }
        if (this.maxSpeed != -1.0) {
            cart.setMaxSpeed(this.maxSpeed);
        }
    }
}

