/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.minecart;

import java.util.Collection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.MinecartItemPickup;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitMinecartItemPickup
extends MinecartItemPickup
implements Listener {
    public BukkitMinecartItemPickup(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Minecart && vehicle instanceof InventoryHolder) {
            Inventory inventory = ((InventoryHolder)vehicle).getInventory();
            for (Entity entity : vehicle.getNearbyEntities(1.0, 1.0, 1.0)) {
                if (!(entity instanceof Item)) continue;
                Item item = (Item)entity;
                Collection leftovers = inventory.addItem(new ItemStack[]{item.getItemStack()}).values();
                if (leftovers.isEmpty()) {
                    item.remove();
                    continue;
                }
                item.setItemStack(leftovers.toArray(new ItemStack[0])[0]);
            }
        }
    }
}

