/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.minecart;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.MinecartImpactDamage;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitMinecartImpactDamage
extends MinecartImpactDamage
implements Listener {
    private static final Vector HALF_BLOCK_UP = new Vector(0.0, 0.5, 0.0);

    public BukkitMinecartImpactDamage(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleEntityCollision(VehicleEntityCollisionEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        if (!this.removeOtherCarts && event.getEntity() instanceof Minecart) {
            return;
        }
        if (!this.damagePlayers && event.getEntity() instanceof Player) {
            return;
        }
        if (!this.emptyCartsImpact && event.getVehicle() instanceof RideableMinecart && event.getVehicle().isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.isInsideVehicle()) {
                return;
            }
            living.damage(5.0);
            try {
                living.setVelocity(event.getVehicle().getVelocity().normalize().multiply(1.2).add(HALF_BLOCK_UP));
            }
            catch (IllegalArgumentException e) {
                living.setVelocity(HALF_BLOCK_UP);
            }
        } else if (this.removeOtherCarts && event.getEntity() instanceof Minecart && event.getEntity().isEmpty()) {
            event.getEntity().remove();
        } else {
            return;
        }
        event.setCancelled(true);
    }
}

