/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.minecart;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.mechanics.minecart.BukkitTemporaryCart;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.MechanicTypes;
import org.enginehub.craftbook.mechanics.minecart.MinecartExitRemover;
import org.enginehub.craftbook.mechanics.minecart.TemporaryCart;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitMinecartExitRemover
extends MinecartExitRemover
implements Listener {
    public BukkitMinecartExitRemover(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleExit(VehicleExitEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof RideableMinecart) {
            TemporaryCart temporaryCart;
            RideableMinecart cart = (RideableMinecart)vehicle;
            if (cart.isDead() || !cart.isValid()) {
                return;
            }
            Optional<TemporaryCart> temporaryCart2 = CraftBook.getInstance().getPlatform().getMechanicManager().getMechanic(MechanicTypes.TEMPORARY_CART.get());
            if (temporaryCart2.isPresent() && (temporaryCart = temporaryCart2.get()) instanceof BukkitTemporaryCart) {
                BukkitTemporaryCart bukkitTemporaryCart = (BukkitTemporaryCart)temporaryCart;
                if (cart.getPersistentDataContainer().has(bukkitTemporaryCart.getTemporaryCartKey(), PersistentDataType.BYTE)) {
                    return;
                }
            }
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), (Runnable)new MinecartRemover(event.getExited(), cart));
        }
    }

    private class MinecartRemover
    implements Runnable {
        private final LivingEntity passenger;
        private final RideableMinecart minecart;

        private MinecartRemover(LivingEntity passenger, RideableMinecart minecart) {
            this.passenger = passenger;
            this.minecart = minecart;
        }

        @Override
        public void run() {
            if (!this.minecart.isValid() || this.minecart.isDead() || !this.minecart.isEmpty()) {
                return;
            }
            if (BukkitMinecartExitRemover.this.giveItem) {
                ItemStack stack = new ItemStack(this.minecart.getMinecartMaterial(), 1);
                LivingEntity livingEntity = this.passenger;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (!player.getInventory().addItem(new ItemStack[]{stack}).isEmpty()) {
                        this.passenger.getLocation().getWorld().dropItemNaturally(this.passenger.getLocation(), stack);
                    }
                } else if (this.passenger != null) {
                    this.passenger.getLocation().getWorld().dropItemNaturally(this.passenger.getLocation(), stack);
                } else {
                    this.minecart.getLocation().getWorld().dropItemNaturally(this.minecart.getLocation(), stack);
                }
            }
            this.minecart.remove();
        }
    }
}

