/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.minecart;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.minecart.MinecartEmptyDecay;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitMinecartEmptyDecay
extends MinecartEmptyDecay
implements Listener {
    public BukkitMinecartEmptyDecay(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleExit(VehicleExitEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof RideableMinecart)) {
            return;
        }
        RideableMinecart rideableMinecart = (RideableMinecart)vehicle;
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new Decay(rideableMinecart), (long)this.decayDelay);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (Entity ent : event.getChunk().getEntities()) {
            RideableMinecart cart;
            if (!(ent instanceof RideableMinecart) || !(cart = (RideableMinecart)ent).isValid() || !cart.isEmpty()) continue;
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new Decay(cart), (long)this.decayDelay);
        }
    }

    private record Decay(RideableMinecart cart) implements Runnable
    {
        @Override
        public void run() {
            if (!this.cart.isValid() || !this.cart.isEmpty()) {
                return;
            }
            this.cart.remove();
        }
    }
}

