/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.headdrops;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.entity.EntityType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.craftbook.bukkit.mechanics.headdrops.HeadDropsCommands;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class HeadDropsCommandsRegistration
implements CommandRegistration<HeadDropsCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<EntityType> entityType_Key = Key.of(EntityType.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private HeadDropsCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument entityTypePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"piston.argument.Entity Type"), (Component)TextComponent.of((String)"The entity type to spawn the head of")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(entityType_Key)).build();
    private final ArgAcceptingCommandFlag otherPlayerPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"The player to target")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.otherPlayer")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag amountPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Amount to give")).withRequiredArg().argNamed(TranslatableComponent.of((String)"piston.argument.amount")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag silentPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Silence output")).build();

    private HeadDropsCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static HeadDropsCommandsRegistration builder() {
        return new HeadDropsCommandsRegistration();
    }

    public HeadDropsCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public HeadDropsCommandsRegistration containerInstance(HeadDropsCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    public HeadDropsCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public HeadDropsCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("give", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Gives the player the headdrops item."));
            b.parts((Collection)ImmutableList.of((Object)this.entityTypePart, (Object)this.otherPlayerPart, (Object)this.amountPart, (Object)this.silentPart));
            b.action(this::cmd$give);
            Method commandMethod = RegistrationUtil.getCommandMethod(HeadDropsCommands.class, (String)"giveItem", (Class[])new Class[]{Actor.class, EntityType.class, String.class, Integer.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$give(CommandParameters parameters) throws AuthorizationException, CraftBookException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(HeadDropsCommands.class, (String)"giveItem", (Class[])new Class[]{Actor.class, EntityType.class, String.class, Integer.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.giveItem(this.extract$actor(parameters), this.extract$entityType(parameters), this.extract$otherPlayer(parameters), this.extract$amount(parameters), this.extract$silent(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private EntityType extract$entityType(CommandParameters parameters) {
        return (EntityType)this.entityTypePart.value(parameters).asSingle(entityType_Key);
    }

    private String extract$otherPlayer(CommandParameters parameters) {
        return (String)this.otherPlayerPart.value(parameters).asSingle(string_Key);
    }

    private int extract$amount(CommandParameters parameters) {
        return (Integer)this.amountPart.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$silent(CommandParameters parameters) {
        return this.silentPart.in(parameters);
    }
}

