/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.headdrops;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitCraftBookPlayer;
import org.enginehub.craftbook.bukkit.mechanics.headdrops.BukkitHeadDrops;
import org.enginehub.craftbook.bukkit.mechanics.headdrops.HeadDropsCommandsRegistration;
import org.enginehub.craftbook.exception.CraftBookException;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;
import org.enginehub.piston.gen.CommandRegistration;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class HeadDropsCommands {
    private final BukkitHeadDrops headDrops;

    public static void register(CommandManager commandManager, CommandRegistrationHandler registration, BukkitHeadDrops headDrops) {
        registration.register(commandManager, (CommandRegistration)HeadDropsCommandsRegistration.builder(), (Object)new HeadDropsCommands(headDrops));
    }

    private HeadDropsCommands(BukkitHeadDrops headDrops) {
        this.headDrops = headDrops;
    }

    @Command(name="give", desc="Gives the player the headdrops item.")
    @CommandPermissions(value={"craftbook.headdrops.give"})
    public void giveItem(Actor actor, @Arg(name="Entity Type", desc="The entity type to spawn the head of") com.sk89q.worldedit.world.entity.EntityType entityType, @ArgFlag(name=112, desc="The player to target") String otherPlayer, @ArgFlag(name=97, desc="Amount to give", def={"1"}) int amount, @Switch(name=115, desc="Silence output") boolean silent) throws AuthorizationException, CraftBookException {
        Player player;
        if (otherPlayer != null) {
            player = Bukkit.getPlayer((String)otherPlayer);
        } else {
            if (!(actor instanceof CraftBookPlayer)) {
                throw new CraftBookException((Component)TranslatableComponent.of((String)"craftbook.command.player-required"));
            }
            player = ((BukkitCraftBookPlayer)actor).getPlayer();
        }
        if (player == null) {
            throw new CraftBookException((Component)TranslatableComponent.of((String)"craftbook.command.unknown-player"));
        }
        if (!actor.hasPermission("craftbook.headdrops.give" + (otherPlayer != null ? ".others" : "") + "." + entityType.id())) {
            throw new AuthorizationException();
        }
        EntityType bukkitEntityType = BukkitAdapter.adapt((com.sk89q.worldedit.world.entity.EntityType)entityType);
        ItemStack toDrop = this.headDrops.createFromEntityType(bukkitEntityType);
        if (toDrop != null) {
            toDrop.setAmount(amount);
        }
        if (toDrop == null || !player.getInventory().addItem(new ItemStack[]{toDrop}).isEmpty()) {
            actor.printError((Component)TranslatableComponent.of((String)"craftbook.headdrops.give.failed", (Component[])new Component[]{TextComponent.of((String)player.getName(), (TextColor)TextColor.WHITE), TextComponent.of((String)bukkitEntityType.translationKey(), (TextColor)TextColor.WHITE)}));
            return;
        }
        if (!silent) {
            actor.printInfo((Component)TranslatableComponent.of((String)"craftbook.headdrops.give", (Component[])new Component[]{TranslatableComponent.of((String)bukkitEntityType.translationKey(), (TextColor)TextColor.WHITE), TextComponent.of((String)player.getName(), (TextColor)TextColor.WHITE)}));
        }
    }
}

