/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.headdrops;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.google.common.collect.Maps;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.mechanics.headdrops.HeadDropsCommands;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.headdrops.HeadDrops;
import org.enginehub.craftbook.mechanics.headdrops.SkinData;
import org.enginehub.craftbook.util.EventUtil;
import org.jspecify.annotations.Nullable;

public class BukkitHeadDrops
extends HeadDrops
implements Listener {
    private static final Map<EntityType, PlayerProfile> TEXTURE_MAP = Maps.newHashMap();
    protected static final String HEAD_NAME = "cb-headdrops";
    private static final UUID DEFAULT_UUID = UUID.fromString("a233eb4b-4cab-42cd-9fd9-7e7b9a3f74be");
    private final NamespacedKey headDropsEntityKey = new NamespacedKey("craftbook", "head_drops_entity");
    private HashMap<NamespacedKey, Double> customDropRates;
    private HashMap<NamespacedKey, PlayerProfile> customSkins;
    private static final Set<EntityType> IGNORED_ENTITIES;

    protected static PlayerProfile createProfile(String texture) {
        PlayerProfile profile = Bukkit.createProfile((UUID)DEFAULT_UUID, (String)HEAD_NAME);
        profile.setProperty(new ProfileProperty("textures", texture));
        return profile;
    }

    public BukkitHeadDrops(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.registerTopLevelWithSubCommands("headdrops", List.of(), "CraftBook HeadDrops Commands", (commandManager, registration) -> HeadDropsCommands.register(commandManager, registration, this));
    }

    @Override
    public void disable() {
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.unregisterTopLevel("headdrops");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDeath(EntityDeathEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (this.playerKillsOnly && event.getEntity().getKiller() == null) {
            return;
        }
        if (event.getEntity().getKiller() != null && !event.getEntity().getKiller().hasPermission("craftbook.headdrops.drops")) {
            return;
        }
        if (event.getEntityType().getName() == null) {
            return;
        }
        NamespacedKey typeName = event.getEntityType().getKey();
        double chance = Math.min(1.0, this.dropRate);
        if (this.customDropRates.containsKey(typeName)) {
            chance = Math.min(1.0, this.customDropRates.get(typeName));
        }
        if (event.getEntity().getKiller() != null && event.getEntity().getKiller().getInventory().getItemInMainHand().containsEnchantment(Enchantment.LOOTING)) {
            chance = Math.min(1.0, chance + this.lootingModifier * (double)event.getEntity().getKiller().getInventory().getItemInMainHand().getEnchantmentLevel(Enchantment.LOOTING));
        }
        if (ThreadLocalRandom.current().nextDouble() > chance) {
            return;
        }
        ItemStack toDrop = null;
        if (event.getEntityType() == EntityType.PLAYER && this.enablePlayers) {
            PlayerProfile playerProfile = ((Player)event.getEntity()).getPlayerProfile();
            toDrop = new ItemStack(Material.PLAYER_HEAD, 1);
            SkullMeta meta = (SkullMeta)toDrop.getItemMeta();
            meta.setPlayerProfile(playerProfile);
            meta.displayName((Component)Component.text((String)(playerProfile.getName() + "'s Head")));
            toDrop.setItemMeta((ItemMeta)meta);
        } else if (this.enableMobs) {
            ItemStack newStack;
            if (this.overrideNatural) {
                switch (event.getEntityType()) {
                    case ZOMBIE: 
                    case GIANT: {
                        ItemStack itemStack = new ItemStack(Material.ZOMBIE_HEAD, 1);
                        break;
                    }
                    case CREEPER: {
                        ItemStack itemStack = new ItemStack(Material.CREEPER_HEAD, 1);
                        break;
                    }
                    case SKELETON: {
                        ItemStack itemStack = new ItemStack(Material.SKELETON_SKULL, 1);
                        break;
                    }
                    case WITHER_SKELETON: {
                        ItemStack itemStack = new ItemStack(Material.WITHER_SKELETON_SKULL, 1);
                        break;
                    }
                    case ENDER_DRAGON: {
                        ItemStack itemStack = new ItemStack(Material.DRAGON_HEAD, 1);
                        break;
                    }
                    case PIGLIN: {
                        ItemStack itemStack = new ItemStack(Material.PIGLIN_HEAD, 1);
                        break;
                    }
                    default: {
                        ItemStack itemStack = toDrop = null;
                    }
                }
            }
            if ((newStack = this.createFromEntityType(event.getEntityType())) != null) {
                toDrop = newStack;
            }
        } else {
            return;
        }
        if (toDrop != null) {
            event.getEntity().getWorld().dropItemNaturally(event.getEntity().getLocation(), toDrop);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.nameOnClick || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clicked = event.getClickedBlock();
        if (clicked == null) {
            return;
        }
        Material clickedType = clicked.getType();
        if (clickedType == Material.PLAYER_HEAD || clickedType == Material.PLAYER_WALL_HEAD) {
            Skull skull = (Skull)clicked.getState(false);
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
            if (skull.getPersistentDataContainer().has(this.headDropsEntityKey, PersistentDataType.STRING)) {
                String entityTypeId = (String)skull.getPersistentDataContainer().get(this.headDropsEntityKey, PersistentDataType.STRING);
                EntityType entityType = (EntityType)Registry.ENTITY_TYPE.get(this.parseKey(Objects.requireNonNull(entityTypeId)));
                if (entityType == null || entityType.getName() == null) {
                    return;
                }
                try {
                    player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)com.sk89q.worldedit.util.formatting.text.TranslatableComponent.of((String)"craftbook.headdrops.click-message.mob", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{com.sk89q.worldedit.util.formatting.text.TranslatableComponent.of((String)entityType.translationKey())}));
                }
                catch (IllegalArgumentException e) {
                    player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)com.sk89q.worldedit.util.formatting.text.TranslatableComponent.of((String)"craftbook.headdrops.click-message.mob", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)entityType.getKey().getKey().replace("_", " "))}));
                }
            } else {
                PlayerProfile profile = skull.getPlayerProfile();
                if (profile == null || profile.getName() == null || profile.getName().equals(HEAD_NAME)) {
                    return;
                }
                player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)com.sk89q.worldedit.util.formatting.text.TranslatableComponent.of((String)"craftbook.headdrops.click-message.player", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)profile.getName())}));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getItemInHand().getType() != Material.PLAYER_HEAD) {
            return;
        }
        ItemMeta itemMeta = event.getItemInHand().getItemMeta();
        if (!itemMeta.getPersistentDataContainer().has(this.headDropsEntityKey, PersistentDataType.STRING)) {
            return;
        }
        String existingData = (String)itemMeta.getPersistentDataContainer().get(this.headDropsEntityKey, PersistentDataType.STRING);
        Skull state = (Skull)event.getBlockPlaced().getState(false);
        state.getPersistentDataContainer().set(this.headDropsEntityKey, PersistentDataType.STRING, (Object)Objects.requireNonNull(existingData));
        state.update();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Block block = event.getBlock();
        Material blockType = block.getType();
        if (blockType == Material.PLAYER_HEAD || blockType == Material.PLAYER_WALL_HEAD) {
            Skull skull = (Skull)block.getState(false);
            if (!skull.getPersistentDataContainer().has(this.headDropsEntityKey, PersistentDataType.STRING)) {
                return;
            }
            String entityTypeId = Objects.requireNonNull((String)skull.getPersistentDataContainer().get(this.headDropsEntityKey, PersistentDataType.STRING));
            EntityType type = (EntityType)Registry.ENTITY_TYPE.get(this.parseKey(entityTypeId));
            if (type == null || type.getName() == null) {
                return;
            }
            PlayerProfile profile = TEXTURE_MAP.get(type);
            if (profile == null) {
                return;
            }
            ItemStack stack = new ItemStack(Material.PLAYER_HEAD, 1);
            SkullMeta meta = (SkullMeta)stack.getItemMeta();
            meta.setPlayerProfile(profile);
            meta.getPersistentDataContainer().set(this.headDropsEntityKey, PersistentDataType.STRING, (Object)entityTypeId);
            meta.displayName(((TranslatableComponent)Component.translatable((String)type.translationKey()).append((Component)Component.text((String)" Head"))).style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE)));
            stack.setItemMeta((ItemMeta)meta);
            event.setCancelled(true);
            event.getBlock().setType(Material.AIR);
            event.getBlock().getWorld().dropItemNaturally(event.getBlock().getLocation().toCenterLocation(), stack);
        }
    }

    protected @Nullable ItemStack createFromEntityType(EntityType entityType) {
        PlayerProfile profile = TEXTURE_MAP.get(entityType);
        NamespacedKey entityKey = entityType.getKey();
        if (this.customSkins.containsKey(entityKey)) {
            profile = this.customSkins.get(entityKey);
        }
        if (profile != null) {
            ItemStack toDrop = new ItemStack(Material.PLAYER_HEAD, 1);
            ItemMeta itemMeta = toDrop.getItemMeta();
            if (itemMeta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)itemMeta;
                skullMeta.displayName(((TranslatableComponent)Component.translatable((String)entityType.translationKey()).append((Component)Component.text((String)" Head"))).style(Style.style().decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE)));
                skullMeta.setPlayerProfile(profile);
                skullMeta.getPersistentDataContainer().set(this.headDropsEntityKey, PersistentDataType.STRING, (Object)entityKey.toString());
                toDrop.setItemMeta((ItemMeta)skullMeta);
            } else {
                CraftBook.LOGGER.warn("Spigot has failed to set a HeadDrop item to a head!");
            }
            return toDrop;
        }
        return null;
    }

    private NamespacedKey parseKey(String name) {
        if (name.contains(":")) {
            String[] nameParts = name.split(":");
            return new NamespacedKey(nameParts[0], nameParts[1]);
        }
        return NamespacedKey.minecraft((String)name);
    }

    @Override
    public void loadFromConfiguration(YAMLProcessor config) {
        super.loadFromConfiguration(config);
        config.setComment("drop-rates", "A list of custom drop rates for different mobs");
        this.customDropRates = new HashMap();
        if (config.getKeys("drop-rates") != null) {
            for (String key : config.getKeys("drop-rates")) {
                this.customDropRates.put(this.parseKey(key), config.getDouble("drop-rates." + key));
            }
        } else {
            config.addNode("drop-rates");
        }
        config.setComment("custom-skins", "A list of custom skins for different mobs");
        this.customSkins = new HashMap();
        if (config.getKeys("custom-skins") != null) {
            for (String key : config.getKeys("custom-skins")) {
                this.customSkins.put(this.parseKey(key), BukkitHeadDrops.createProfile(config.getString("custom-skins." + key)));
            }
        } else {
            config.addNode("custom-skins");
        }
    }

    private static void printMissingSkins() {
        String missingText = Registry.ENTITY_TYPE.stream().filter(type -> !IGNORED_ENTITIES.contains(type) && type.isAlive()).filter(type -> !TEXTURE_MAP.containsKey(type)).map(EntityType::getKey).map(NamespacedKey::toString).collect(Collectors.joining(", "));
        if (!missingText.isEmpty()) {
            CraftBook.LOGGER.warn(missingText);
        }
    }

    static {
        if (System.getenv("CRAFTBOOK_DOCGEN") == null) {
            SkinData.addDefaultSkinData((entityType, textureString) -> {
                if (entityType != null) {
                    TEXTURE_MAP.put(BukkitAdapter.adapt((com.sk89q.worldedit.world.entity.EntityType)entityType), BukkitHeadDrops.createProfile(textureString));
                }
            });
        }
        IGNORED_ENTITIES = Set.of(EntityType.PLAYER, EntityType.ZOMBIE, EntityType.CREEPER, EntityType.SKELETON, EntityType.WITHER_SKELETON, EntityType.ARMOR_STAND, EntityType.ENDER_DRAGON, EntityType.PIGLIN, EntityType.UNKNOWN, EntityType.MANNEQUIN);
    }
}

