/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.dispenser.recipe;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.bukkit.mechanics.dispenser.recipe.DispenserRecipe;

public class EntityMover
extends DispenserRecipe {
    private final double velocityMultiplier;

    public EntityMover(String id, double velocityMultiplier, Material[] materials) {
        super(id, materials);
        this.velocityMultiplier = velocityMultiplier;
    }

    @Override
    public void apply(Block block, ItemStack item, BlockFace face) {
        Block searchPoint = block.getRelative(face);
        BoundingBox cubeBox = BoundingBox.of((Block)searchPoint).expand(face, 3.0);
        for (Entity e : block.getWorld().getNearbyEntities(cubeBox)) {
            Vector dir = new Vector(face.getModX(), face.getModY(), face.getModZ());
            e.setVelocity(e.getVelocity().add(dir).normalize().multiply(this.velocityMultiplier));
        }
    }
}

