/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.dispenser.recipe;

import com.sk89q.worldedit.registry.Keyed;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public abstract class DispenserRecipe
implements Keyed {
    private final String id;
    private final Material[] recipe;

    public DispenserRecipe(String id, Material[] materials) {
        this.id = id;
        this.recipe = materials;
    }

    protected Vector generateVelocity(BlockFace direction) {
        double speed = ThreadLocalRandom.current().nextDouble() * 0.1 + 0.2;
        double x = ThreadLocalRandom.current().nextGaussian() * 0.044999999 + (double)direction.getModX() * speed;
        double y = ThreadLocalRandom.current().nextGaussian() * 0.044999999 + (double)0.2f;
        double z = ThreadLocalRandom.current().nextGaussian() * 0.044999999 + (double)direction.getModZ() * speed;
        return new Vector(x, y, z);
    }

    protected Location generateLocation(Block block, BlockFace direction) {
        Location firePosition = block.getLocation().toCenterLocation();
        firePosition.add(0.7 * (double)direction.getModX(), 0.7 * (double)direction.getModY(), 0.7 * (double)direction.getModZ());
        firePosition.setY(firePosition.getY() - (direction.getModY() != 0 ? 0.125 : 0.15625));
        return firePosition;
    }

    public abstract void apply(Block var1, ItemStack var2, BlockFace var3);

    public Material[] getRecipe() {
        return this.recipe;
    }

    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        DispenserRecipe otherRecipe;
        return this == o || o instanceof DispenserRecipe && Objects.equals(this.id, (otherRecipe = (DispenserRecipe)o).id()) && Arrays.equals(this.recipe, otherRecipe.recipe);
    }

    public int hashCode() {
        return Arrays.hashCode(this.recipe);
    }
}

