/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.dispenser;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.registry.Keyed;
import com.sk89q.worldedit.registry.NamespacedRegistry;
import com.sk89q.worldedit.registry.Registry;
import io.papermc.paper.event.block.BlockPreDispenseEvent;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.bukkit.mechanics.dispenser.recipe.Cannon;
import org.enginehub.craftbook.bukkit.mechanics.dispenser.recipe.DispenserRecipe;
import org.enginehub.craftbook.bukkit.mechanics.dispenser.recipe.EntityMover;
import org.enginehub.craftbook.bukkit.mechanics.dispenser.recipe.FireArrows;
import org.enginehub.craftbook.bukkit.mechanics.dispenser.recipe.ItemShooter;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.dispenser.DispenserRecipes;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ItemUtil;
import org.jspecify.annotations.Nullable;

public class BukkitDispenserRecipes
extends DispenserRecipes
implements Listener {
    public static final Registry<DispenserRecipe> REGISTRY = new NamespacedRegistry("dispenser recipe", "craftbook:dispenser_recipe", "craftbook");

    public BukkitDispenserRecipes(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        if (this.xpShooterEnable) {
            this.addRecipe(new ItemShooter("craftbook:xp_shooter", Material.EXPERIENCE_BOTTLE, new Material[]{Material.AIR, Material.REDSTONE, Material.AIR, Material.REDSTONE, Material.GLASS_BOTTLE, Material.REDSTONE, Material.AIR, Material.REDSTONE, Material.AIR}));
        }
        if (this.snowShooterEnable) {
            this.addRecipe(new ItemShooter("craftbook:snow_shooter", Material.SNOWBALL, new Material[]{Material.AIR, Material.SNOW_BLOCK, Material.AIR, Material.SNOW_BLOCK, Material.POTION, Material.SNOW_BLOCK, Material.AIR, Material.SNOW_BLOCK, Material.AIR}));
        }
        if (this.fireArrowsEnable) {
            this.addRecipe(new FireArrows("craftbook:fire_arrows", new Material[]{Material.AIR, Material.FIRE_CHARGE, Material.AIR, Material.FIRE_CHARGE, Material.ARROW, Material.FIRE_CHARGE, Material.AIR, Material.FIRE_CHARGE, Material.AIR}));
        }
        if (this.fanEnable) {
            this.addRecipe(new EntityMover("craftbook:fan", 10.0, new Material[]{Material.COBWEB, Material.OAK_LEAVES, Material.COBWEB, Material.OAK_LEAVES, Material.PISTON, Material.OAK_LEAVES, Material.COBWEB, Material.OAK_LEAVES, Material.COBWEB}));
        }
        if (this.vacuumEnable) {
            this.addRecipe(new EntityMover("craftbook:vacuum", -5.0, new Material[]{Material.COBWEB, Material.OAK_LEAVES, Material.COBWEB, Material.OAK_LEAVES, Material.STICKY_PISTON, Material.OAK_LEAVES, Material.COBWEB, Material.OAK_LEAVES, Material.COBWEB}));
        }
        if (this.cannonEnable) {
            this.addRecipe(new Cannon("craftbook:cannon", new Material[]{Material.FIRE_CHARGE, Material.GUNPOWDER, Material.FIRE_CHARGE, Material.GUNPOWDER, Material.TNT, Material.GUNPOWDER, Material.FIRE_CHARGE, Material.GUNPOWDER, Material.FIRE_CHARGE}));
        }
    }

    @Override
    public void disable() {
        REGISTRY.clear();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockDispense(BlockPreDispenseEvent event) {
        if (!EventUtil.passesFilter((Event)event) || event.getBlock().getType() != Material.DISPENSER) {
            return;
        }
        Block block = event.getBlock();
        Dispenser dispenser = (Dispenser)block.getState(false);
        Directional dispenserData = (Directional)block.getBlockData();
        BlockFace direction = dispenserData.getFacing();
        Inventory inventory = dispenser.getInventory();
        ItemStack[] stacks = inventory.getContents();
        for (DispenserRecipe r : REGISTRY.values()) {
            Material[] recipe = r.getRecipe();
            if (!BukkitDispenserRecipes.checkRecipe(stacks, recipe)) continue;
            r.apply(block, event.getItemStack(), direction);
            for (int i = 0; i < stacks.length; ++i) {
                if (recipe[i] == Material.AIR) continue;
                stacks[i] = ItemUtil.getUsedItem(stacks[i]);
            }
            inventory.setContents(stacks);
            block.getWorld().playSound(block.getLocation().toCenterLocation(), Sound.BLOCK_DISPENSER_LAUNCH, SoundCategory.BLOCKS, 1.0f, 1.0f);
            block.getWorld().playEffect(block.getLocation().toCenterLocation(), Effect.SMOKE, (Object)direction);
            event.setCancelled(true);
            return;
        }
    }

    private static boolean checkRecipe(@Nullable ItemStack[] stacks, Material[] recipe) {
        for (int i = 0; i < stacks.length; ++i) {
            Material id;
            ItemStack stack = stacks[i];
            Material material = id = stack == null ? Material.AIR : stack.getType();
            if (recipe[i] == id) continue;
            return false;
        }
        return true;
    }

    public void addRecipe(DispenserRecipe recipe) {
        Preconditions.checkNotNull((Object)recipe, (Object)"Recipe must not be null");
        REGISTRY.register(recipe.id(), (Keyed)recipe);
    }
}

