/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.boat;

import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.boat.BoatImpactDamage;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitBoatImpactDamage
extends BoatImpactDamage
implements Listener {
    private static final Vector HALF_BLOCK_UP = new Vector(0.0, 0.5, 0.0);

    public BukkitBoatImpactDamage(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleEntityCollision(VehicleEntityCollisionEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!(event.getVehicle() instanceof Boat) || event.getVehicle().isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living.isInsideVehicle()) {
                return;
            }
            living.damage(5.0);
            try {
                living.setVelocity(living.getLocation().getDirection().normalize().multiply(1.2).add(HALF_BLOCK_UP));
            }
            catch (IllegalArgumentException e) {
                living.setVelocity(HALF_BLOCK_UP);
            }
        } else if (this.removeOtherBoats && event.getEntity() instanceof Boat && event.getEntity().isEmpty()) {
            event.getEntity().remove();
        } else {
            return;
        }
        event.setCancelled(true);
    }
}

