/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.boat;

import org.bukkit.Bukkit;
import org.bukkit.entity.Boat;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.boat.BoatExitRemover;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitBoatExitRemover
extends BoatExitRemover
implements Listener {
    public BukkitBoatExitRemover(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleExit(VehicleExitEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (vehicle instanceof Boat) {
            Boat boat = (Boat)vehicle;
            if (boat.isDead() || !boat.isValid()) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), (Runnable)new BoatRemover(event.getExited(), boat));
        }
    }

    private class BoatRemover
    implements Runnable {
        private final LivingEntity passenger;
        private final Boat boat;

        private BoatRemover(LivingEntity passenger, Boat boat) {
            this.passenger = passenger;
            this.boat = boat;
        }

        @Override
        public void run() {
            if (!this.boat.isValid() || this.boat.isDead() || !this.boat.isEmpty()) {
                return;
            }
            if (BukkitBoatExitRemover.this.giveItem) {
                ItemStack stack = new ItemStack(this.boat.getBoatMaterial(), 1);
                LivingEntity livingEntity = this.passenger;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (!player.getInventory().addItem(new ItemStack[]{stack}).isEmpty()) {
                        this.passenger.getLocation().getWorld().dropItemNaturally(this.passenger.getLocation(), stack);
                    }
                } else if (this.passenger.isValid()) {
                    this.passenger.getLocation().getWorld().dropItemNaturally(this.passenger.getLocation(), stack);
                } else {
                    this.boat.getLocation().getWorld().dropItemNaturally(this.boat.getLocation(), stack);
                }
            }
            this.boat.remove();
        }
    }
}

