/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.boat;

import org.bukkit.Bukkit;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.boat.BoatEmptyDecay;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitBoatEmptyDecay
extends BoatEmptyDecay
implements Listener {
    public BukkitBoatEmptyDecay(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onVehicleExit(VehicleExitEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Boat)) {
            return;
        }
        Boat boat = (Boat)vehicle;
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new Decay(boat), (long)this.decayDelay);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (Entity ent : event.getChunk().getEntities()) {
            Boat boat;
            if (!(ent instanceof Boat) || !(boat = (Boat)ent).isValid() || !boat.isEmpty()) continue;
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new Decay(boat), (long)this.decayDelay);
        }
    }

    private record Decay(Boat boat) implements Runnable
    {
        @Override
        public void run() {
            if (!this.boat.isValid() || !this.boat.isEmpty()) {
                return;
            }
            this.boat.remove();
        }
    }
}

