/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.betterai;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import com.destroystokyo.paper.entity.ai.VanillaGoal;
import java.util.EnumSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;

public class FleeFromWeaponsGoal
implements Goal<Creature> {
    private static final GoalKey<Creature> key = GoalKey.of(Creature.class, (NamespacedKey)new NamespacedKey("craftbook", "flee_from_weapons"));
    private final Creature creature;

    public FleeFromWeaponsGoal(Creature creature) {
        this.creature = creature;
    }

    private boolean isNearbyPlayerWithWeapon() {
        List entities = this.creature.getNearbyEntities(5.0, 5.0, 5.0);
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            Material mainHandType = player.getInventory().getItemInMainHand().getType();
            Material offHandType = player.getInventory().getItemInOffHand().getType();
            if (!Tag.ITEMS_SWORDS.isTagged((Keyed)mainHandType) && !Tag.ITEMS_SWORDS.isTagged((Keyed)offHandType)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldActivate() {
        return !this.creature.isDead() && this.isNearbyPlayerWithWeapon();
    }

    public void start() {
        Goal panicGoal;
        if (this.isNearbyPlayerWithWeapon() && (panicGoal = Bukkit.getServer().getMobGoals().getGoal((Mob)this.creature, VanillaGoal.PANIC)) != null) {
            panicGoal.start();
        }
    }

    public void tick() {
        Goal panicGoal;
        if (this.isNearbyPlayerWithWeapon() && (panicGoal = Bukkit.getServer().getMobGoals().getGoal((Mob)this.creature, VanillaGoal.PANIC)) != null) {
            panicGoal.start();
        }
    }

    public GoalKey<Creature> getKey() {
        return key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE);
    }
}

