/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.betterai;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.VanillaGoal;
import com.destroystokyo.paper.event.entity.EntityAddToWorldEvent;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.mechanics.betterai.AttackPassiveGoal;
import org.enginehub.craftbook.bukkit.mechanics.betterai.FleeFromWeaponsGoal;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.betterai.BetterAI;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitBetterAI
extends BetterAI
implements Listener {
    private static final NamespacedKey SIZE_VARIANCE = new NamespacedKey("craftbook", "size_variance");
    private static final NamespacedKey SIZE_VARIANCE_BREEDING = new NamespacedKey("craftbook", "size_variance_breeding");

    public BukkitBetterAI(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityCreate(EntityAddToWorldEvent event) {
        AttributeInstance attributeInstance;
        LivingEntity livingEntity;
        CreatureSpawnEvent.SpawnReason spawnReason;
        Entity entity;
        if (BukkitBetterAI.areAllDisabled(this.attackPassive, this.sizeVariance, this.fleeFromWeapons) || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (BukkitBetterAI.isEntityEnabled(event.getEntity(), this.attackPassive) && (entity = event.getEntity()) instanceof Monster) {
            Monster monster = (Monster)entity;
            Bukkit.getServer().getMobGoals().addGoal((Mob)monster, 5, (Goal)new AttackPassiveGoal(monster, this.attackPassiveIgnoreHostileMounts));
        }
        if (BukkitBetterAI.isEntityEnabled(event.getEntity(), this.fleeFromWeapons) && (entity = event.getEntity()) instanceof Creature) {
            Creature creature = (Creature)entity;
            if (Bukkit.getServer().getMobGoals().hasGoal((Mob)creature, VanillaGoal.PANIC)) {
                Bukkit.getServer().getMobGoals().addGoal((Mob)creature, 5, (Goal)new FleeFromWeaponsGoal(creature));
            } else {
                CraftBookPlugin.inst().getLogger().warning("Attempted to add FleeFromWeaponsGoal to unsupported entity that does not have PANIC goal: " + event.getEntity().getType().key().asString());
            }
        }
        if (BukkitBetterAI.isEntityEnabled(event.getEntity(), this.sizeVariance) && (entity = event.getEntity()) instanceof LivingEntity && (spawnReason = (livingEntity = (LivingEntity)entity).getEntitySpawnReason()) != CreatureSpawnEvent.SpawnReason.BREEDING && spawnReason != CreatureSpawnEvent.SpawnReason.CUSTOM && spawnReason != CreatureSpawnEvent.SpawnReason.COMMAND && (attributeInstance = livingEntity.getAttribute(Attribute.SCALE)).getModifier((Key)SIZE_VARIANCE) == null && attributeInstance.getModifier((Key)SIZE_VARIANCE_BREEDING) == null) {
            attributeInstance.addModifier(new AttributeModifier(SIZE_VARIANCE, (Math.random() - 0.5) * 2.0 * this.sizeVarianceVariability, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityBreed(EntityBreedEvent event) {
        if (BukkitBetterAI.areAllDisabled(this.sizeVariance) || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (this.sizeVarianceAllowBreeding && BukkitBetterAI.isEntityEnabled((Entity)event.getEntity(), this.sizeVariance)) {
            double averageSize = (event.getMother().getAttribute(Attribute.SCALE).getValue() + event.getFather().getAttribute(Attribute.SCALE).getValue()) / 2.0;
            AttributeInstance attributeInstance = event.getEntity().getAttribute(Attribute.SCALE);
            attributeInstance.setBaseValue(averageSize);
            if (attributeInstance.getModifier((Key)SIZE_VARIANCE_BREEDING) == null) {
                attributeInstance.addModifier(new AttributeModifier(SIZE_VARIANCE_BREEDING, (Math.random() - 0.5) * 2.0 * this.sizeVarianceBreedingVariability, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlotGroup.ANY));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntitySearchTarget(EntityTargetEvent event) {
        if (BukkitBetterAI.areAllDisabled(this.enhancedVision) || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getReason() != EntityTargetEvent.TargetReason.CLOSEST_PLAYER && event.getReason() != EntityTargetEvent.TargetReason.CLOSEST_ENTITY && event.getReason() != EntityTargetEvent.TargetReason.RANDOM_TARGET) {
            return;
        }
        if (BukkitBetterAI.isEntityEnabled(event.getEntity(), this.enhancedVision)) {
            int distance;
            Player player;
            if (event.getTarget() == null) {
                return;
            }
            Difficulty diff = event.getEntity().getWorld().getDifficulty();
            LivingEntity enemy = (LivingEntity)event.getEntity();
            Entity entity = event.getTarget();
            if (entity instanceof Player) {
                player = (Player)entity;
                if (!enemy.hasLineOfSight(event.getTarget()) && !player.isSprinting()) {
                    CraftBookPlugin.logDebugMessage("Disabling entity target - Player is not visible.", "ai-mechanics.entity-target.vision");
                    event.setCancelled(true);
                    return;
                }
            }
            if (event.getTarget().getLocation().getBlock().getLightLevel() > (diff == Difficulty.HARD ? (byte)4 : 6) && enemy.hasLineOfSight(event.getTarget())) {
                return;
            }
            entity = event.getTarget();
            if (entity instanceof Player && (player = (Player)entity).isSneaking() && (distance = (int)Math.floor(player.getLocation().distanceSquared(enemy.getLocation()))) != 0 && ThreadLocalRandom.current().nextInt(distance) > (diff == Difficulty.HARD ? 4 : 2)) {
                CraftBookPlugin.logDebugMessage("Disabling entity target - Player is sneaking.", "ai-mechanics.entity-target.vision");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityShootBow(EntityShootBowEvent event) {
        if (BukkitBetterAI.areAllDisabled(this.criticalBow) || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (BukkitBetterAI.isEntityEnabled((Entity)event.getEntity(), this.criticalBow)) {
            int amount;
            switch (event.getEntity().getWorld().getDifficulty()) {
                default: {
                    throw new MatchException(null, null);
                }
                case EASY: {
                    int n = 100;
                    break;
                }
                case HARD: {
                    int n = 20;
                    break;
                }
                case NORMAL: {
                    int n = 50;
                    break;
                }
                case PEACEFUL: {
                    int n = amount = 0;
                }
            }
            if (amount > 0 && ThreadLocalRandom.current().nextInt(amount) == 0) {
                CraftBookPlugin.logDebugMessage("Performing critical hit.", "ai-mechanics.shoot-bow.critical");
                event.getEntity().getWorld().spawnParticle(Particle.CRIT, event.getEntity().getEyeLocation(), 10);
                event.getProjectile().setFireTicks(5000);
            }
        }
    }

    private static boolean isEntityEnabled(Entity ent, Set<String> entities) {
        String id = BukkitAdapter.adapt((EntityType)ent.getType()).id();
        if (id.startsWith("minecraft:") && entities.contains(id.substring("minecraft:".length()))) {
            return true;
        }
        return entities.contains(BukkitAdapter.adapt((EntityType)ent.getType()).id());
    }
}

