/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.betterai;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.jspecify.annotations.Nullable;

class AttackPassiveGoal
implements Goal<Monster> {
    private static final GoalKey<Monster> key = GoalKey.of(Monster.class, (NamespacedKey)new NamespacedKey("craftbook", "attack_passive"));
    private static final int ACTIVE_DISTANCE = 15;
    private static final double SEARCH_DISTANCE = 10.0;
    private static final int FORGET_DISTANCE = 60;
    private final Monster monster;
    private final boolean attackPassiveIgnoreHostileMounts;
    private @Nullable LivingEntity target;

    public AttackPassiveGoal(Monster monster, boolean attackPassiveIgnoreHostileMounts) {
        this.monster = monster;
        this.attackPassiveIgnoreHostileMounts = attackPassiveIgnoreHostileMounts;
    }

    public boolean shouldActivate() {
        return !this.monster.isDead();
    }

    public void start() {
        this.tick();
    }

    public void stop() {
        this.target = null;
        this.monster.setTarget(null);
    }

    public void tick() {
        if (this.target != null) {
            boolean targetValid = this.target.isValid() && !this.target.isDead() && this.target.getWorld().equals((Object)this.monster.getWorld());
            double distanceSquared = this.target.getLocation().distanceSquared(this.monster.getLocation());
            if (targetValid && distanceSquared < 225.0) {
                return;
            }
            if (!targetValid || distanceSquared > 3600.0) {
                this.target = null;
                this.monster.setTarget(null);
            }
        }
        Animals closest = null;
        double closestDist = Double.MAX_VALUE;
        for (Entity ent : this.monster.getNearbyEntities(10.0, 10.0, 10.0)) {
            double dist;
            Animals animal;
            if (!(ent instanceof Animals) || !this.monster.hasLineOfSight((Entity)(animal = (Animals)ent))) continue;
            if (this.attackPassiveIgnoreHostileMounts && !animal.getPassengers().isEmpty()) {
                boolean foundAny = false;
                for (Entity passenger : animal.getPassengers()) {
                    if (!(passenger instanceof Monster)) continue;
                    foundAny = true;
                    break;
                }
                if (foundAny) continue;
            }
            if (!((dist = animal.getLocation().distanceSquared(this.monster.getLocation())) < closestDist)) continue;
            closest = animal;
            closestDist = dist;
        }
        if (closest != null) {
            this.target = closest;
            this.monster.setTarget(this.target);
            CraftBookPlugin.logDebugMessage("Setting target to entity: " + closest.getType().name(), "ai-mechanics.entity-target.attack-passive");
        }
    }

    public GoalKey<Monster> getKey() {
        return key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.TARGET);
    }
}

