/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics.area.clipboard;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import io.papermc.paper.math.Position;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicCommandRegistrar;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.area.clipboard.AreaCommands;
import org.enginehub.craftbook.mechanics.area.clipboard.CopyManager;
import org.enginehub.craftbook.mechanics.area.clipboard.ToggleArea;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.enginehub.craftbook.util.persistence.OwnedSignHelper;

public class BukkitToggleArea
extends ToggleArea
implements Listener {
    public BukkitToggleArea(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.registerTopLevelWithSubCommands("area", List.of("togglearea"), "CraftBook ToggleArea Commands", (commandManager, registration) -> AreaCommands.register(commandManager, registration, this));
    }

    @Override
    public void disable() {
        super.disable();
        MechanicCommandRegistrar registrar = CraftBookPlugin.inst().getCommandManager().getMechanicRegistrar();
        registrar.unregisterTopLevel("area");
        registrar.unregisterTopLevel("togglearea");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        String namespace;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[togglearea]") && !signLine1.equalsIgnoreCase("[toggleareasave]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        String signLine0 = PlainTextComponentSerializer.plainText().serialize(event.line(0));
        if (signLine0.trim().isEmpty()) {
            event.line(0, (Component)Component.text((String)("~" + player.getName()), null, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
            namespace = player.getUniqueId().toString();
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
                if (!SignUtil.isSign(event.getBlock())) {
                    return;
                }
                Sign sign = (Sign)event.getBlock().getState(false);
                String innerLine1 = PlainTextComponentSerializer.plainText().serialize(sign.getSide(event.getSide()).line(1));
                if (!innerLine1.equals("[ToggleArea]") && !innerLine1.equals("[ToggleAreaSave]")) {
                    return;
                }
                OwnedSignHelper.setOwner((TileState)sign, player.getUniqueId());
            });
        } else {
            namespace = signLine0;
        }
        boolean saving = false;
        if (signLine1.equalsIgnoreCase("[togglearea]")) {
            if (!player.hasPermission("craftbook.togglearea.create")) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{com.sk89q.worldedit.util.formatting.text.TextComponent.of((String)this.getMechanicType().getName())}));
                }
                SignUtil.cancelSignChange(event);
                return;
            }
            event.line(1, (Component)Component.text((String)"[ToggleArea]"));
        } else if (signLine1.equalsIgnoreCase("[toggleareasave]")) {
            if (!player.hasPermission("craftbook.togglearea.create.save")) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{com.sk89q.worldedit.util.formatting.text.TextComponent.of((String)this.getMechanicType().getName())}));
                }
                SignUtil.cancelSignChange(event);
                return;
            }
            event.line(1, (Component)Component.text((String)"[ToggleAreaSave]"));
            saving = true;
        }
        ToggleArea.ToggleAreaData toggleAreaData = new ToggleArea.ToggleAreaData(namespace, PlainTextComponentSerializer.plainText().serialize(event.line(2)), PlainTextComponentSerializer.plainText().serialize(event.line(3)));
        if (!this.isValidArea(toggleAreaData)) {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.togglearea.missing-area"));
            SignUtil.cancelSignChange(event);
            return;
        }
        player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)(saving ? "craftbook.togglearea.create.save" : "craftbook.togglearea.create")));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        BukkitChangedSign sign = event.getSign();
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        if (!line1.equals("[ToggleArea]") && !line1.equals("[ToggleAreaSave]")) {
            return;
        }
        if (!player.hasPermission("craftbook.togglearea.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{com.sk89q.worldedit.util.formatting.text.TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{com.sk89q.worldedit.util.formatting.text.TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        ToggleArea.ToggleAreaData toggleAreaData = this.getToggleAreaData(sign);
        if (!this.isValidArea(toggleAreaData)) {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.togglearea.missing-area"));
            event.setCancelled(true);
            return;
        }
        boolean save = line1.equals("[ToggleAreaSave]");
        if (this.toggle(sign, toggleAreaData, save)) {
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.togglearea.toggled"));
        } else {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.togglearea.toggle-failed"));
        }
        event.setCancelled(true);
    }

    private boolean isValidArea(ToggleArea.ToggleAreaData toggleAreaData) {
        if (CopyManager.isExistingArea(toggleAreaData.namespace(), toggleAreaData.areaOn())) {
            if (toggleAreaData.areaOff() == null || toggleAreaData.areaOff().isEmpty() || toggleAreaData.areaOff().equals("--")) {
                return true;
            }
            return CopyManager.isExistingArea(toggleAreaData.namespace(), toggleAreaData.areaOff());
        }
        return false;
    }

    private ToggleArea.ToggleAreaData getToggleAreaData(BukkitChangedSign sign) {
        String namespace = OwnedSignHelper.hasOwner((BlockState)sign.getSign()) ? OwnedSignHelper.getOwner((BlockState)sign.getSign()).toString() : PlainTextComponentSerializer.plainText().serialize(sign.getLine(0));
        String areaOn = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2).replaceText(DASH_REMOVER)).toLowerCase(Locale.ENGLISH);
        String areaOff = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3).replaceText(DASH_REMOVER)).toLowerCase(Locale.ENGLISH);
        return new ToggleArea.ToggleAreaData(namespace, areaOn, areaOff);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!(this.allowRedstone && EventUtil.passesFilter((Event)event) && SignUtil.isSign(event.getBlock()))) {
            return;
        }
        Sign bukkitSign = (Sign)event.getBlock().getState(false);
        Side side = bukkitSign.getInteractableSideFor((Position)event.getSource().getLocation());
        BukkitChangedSign sign = BukkitChangedSign.create(bukkitSign, side);
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        if (!line1.equals("[ToggleArea]") && !line1.equals("[ToggleAreaSave]")) {
            return;
        }
        ToggleArea.ToggleAreaData toggleAreaData = this.getToggleAreaData(sign);
        if (!this.isValidArea(toggleAreaData)) {
            return;
        }
        boolean save = line1.equals("[ToggleAreaSave]");
        this.toggle(sign, toggleAreaData, save);
    }

    private boolean toggle(BukkitChangedSign sign, ToggleArea.ToggleAreaData toggleAreaData, boolean save) {
        try {
            World weWorld = BukkitAdapter.adapt((org.bukkit.World)sign.getBlock().getWorld());
            if (this.checkToggleState(sign)) {
                Clipboard copy = CopyManager.getInstance().load(toggleAreaData.namespace(), toggleAreaData.areaOn());
                if (save) {
                    copy = CopyManager.getInstance().copy(copy.getRegion(), weWorld);
                    CopyManager.getInstance().save(toggleAreaData.namespace(), toggleAreaData.areaOn(), copy);
                }
                if (!toggleAreaData.areaOff().isEmpty() && !toggleAreaData.areaOff().equals("--")) {
                    copy = CopyManager.getInstance().load(toggleAreaData.namespace(), toggleAreaData.areaOff());
                    CopyManager.getInstance().paste(copy, weWorld);
                } else {
                    CopyManager.getInstance().clear(copy, weWorld);
                }
                this.setToggledState(sign, false);
            } else {
                Clipboard copy;
                if (save && !toggleAreaData.areaOff().isEmpty() && !toggleAreaData.areaOff().equals("--")) {
                    copy = CopyManager.getInstance().load(toggleAreaData.namespace(), toggleAreaData.areaOff());
                    copy = CopyManager.getInstance().copy(copy.getRegion(), weWorld);
                    CopyManager.getInstance().save(toggleAreaData.namespace(), toggleAreaData.areaOff(), copy);
                }
                copy = CopyManager.getInstance().load(toggleAreaData.namespace(), toggleAreaData.areaOn());
                CopyManager.getInstance().paste(copy, weWorld);
                this.setToggledState(sign, true);
            }
            return true;
        }
        catch (WorldEditException | IOException e) {
            CraftBook.LOGGER.error("Failed to toggle ToggleArea: " + e.getMessage());
            return false;
        }
    }

    @Override
    public boolean toggleCold(Actor actor, Location location) {
        Block block = BukkitAdapter.adapt((Location)location).getBlock();
        if (!SignUtil.isSign(block)) {
            actor.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.togglearea.toggle.no-sign"));
            return false;
        }
        Sign bukkitSign = (Sign)block.getState(false);
        BukkitChangedSign sign = null;
        for (Side side : Side.values()) {
            BukkitChangedSign testSign = BukkitChangedSign.create(bukkitSign, side);
            String signLine1 = PlainTextComponentSerializer.plainText().serialize(testSign.getLine(1));
            if (!signLine1.equals("[ToggleArea]") && !signLine1.equals("[ToggleAreaSave]")) continue;
            sign = testSign;
            break;
        }
        if (sign == null) {
            return false;
        }
        boolean save = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1)).equalsIgnoreCase("[ToggleAreaSave]");
        ToggleArea.ToggleAreaData toggleAreaData = this.getToggleAreaData(sign);
        return this.toggle(sign, toggleAreaData, save);
    }

    private boolean checkToggleState(BukkitChangedSign sign) {
        String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2)).toLowerCase(Locale.ENGLISH);
        String line4 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3)).toLowerCase(Locale.ENGLISH);
        return TOGGLED_ON_PATTERN.matcher(line3).matches() || !line4.equals("--") && !TOGGLED_ON_PATTERN.matcher(line4).matches();
    }

    private void setToggledState(BukkitChangedSign sign, boolean state) {
        int toToggleOn = state ? 2 : 3;
        int toToggleOff = state ? 3 : 2;
        sign.setLine(toToggleOff, sign.getLine(toToggleOff).replaceText(DASH_REMOVER));
        sign.setLine(toToggleOn, ((TextComponent)Component.text((char)'-').append(sign.getLine(toToggleOn))).append((Component)Component.text((char)'-')));
        this.updateOwnerName(sign);
        sign.update(false);
    }

    private void updateOwnerName(BukkitChangedSign sign) {
        String name;
        if (!OwnedSignHelper.hasOwner((BlockState)sign.getSign())) {
            return;
        }
        UUID owner = OwnedSignHelper.getOwner((BlockState)sign.getSign());
        String existingName = PlainTextComponentSerializer.plainText().serialize(sign.getLine(0));
        if (existingName.startsWith("~")) {
            existingName = existingName.substring(1);
        }
        if ((name = Bukkit.getOfflinePlayer((UUID)owner).getName()) != null && !name.equals(existingName)) {
            sign.setLine(0, (Component)Component.text((String)("~" + name), null, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC}));
        }
    }
}

