/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.ArrayList;
import java.util.HashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SelfTriggerPingEvent;
import org.enginehub.craftbook.bukkit.events.SelfTriggerThinkEvent;
import org.enginehub.craftbook.bukkit.st.BukkitSelfTriggerManager;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanics.XPStorer;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.InventoryUtil;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;

public class BukkitXPStorer
extends XPStorer
implements Listener {
    private final NamespacedKey xpQuantityKey = new NamespacedKey("craftbook", "xp_quantity");
    private ItemStack mergeStack;

    public BukkitXPStorer(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() throws MechanicInitializationException {
        super.enable();
        try {
            this.mergeStack = Bukkit.getServer().getItemFactory().createItemStack(this.bottleExtraData);
        }
        catch (IllegalArgumentException e) {
            CraftBook.LOGGER.error("Failed to parse extra bottle data for XP Storer", (Throwable)e);
            this.mergeStack = new ItemStack(Material.EXPERIENCE_BOTTLE);
        }
    }

    private ItemStack createStack(int bottles) {
        ItemStack stack = this.mergeStack.clone();
        stack.setAmount(Math.min(bottles, 64));
        if (this.bottleXpOverride >= 0) {
            stack.editMeta(meta -> {
                meta.getPersistentDataContainer().set(this.xpQuantityKey, PersistentDataType.INTEGER, (Object)this.bottleXpOverride);
                ArrayList<TextComponent> lore = meta.hasLore() ? new ArrayList<TextComponent>(meta.lore()) : new ArrayList(1);
                lore.add(Component.text((String)("Stored XP: " + this.bottleXpOverride)));
                meta.lore(lore);
            });
        }
        return stack;
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event) || !this.allowOffHand && event.getHand() != EquipmentSlot.HAND || event.getPlayer().getLevel() < 1) {
            return;
        }
        if (!this.block.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)event.getClickedBlock().getBlockData()))) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!this.allowSneaking.doesPass(player.isSneaking())) {
            return;
        }
        int maxBottleCount = Integer.MAX_VALUE;
        if (this.requireBottle) {
            if (event.getItem() == null || event.getItem().getType() != Material.GLASS_BOTTLE) {
                if (!(event.getHand() != EquipmentSlot.HAND || event.getPlayer().getInventory().getItemInMainHand().getType() == Material.GLASS_BOTTLE || this.allowOffHand && event.getPlayer().getInventory().getItemInOffHand().getType() == Material.GLASS_BOTTLE)) {
                    player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.xpstorer.require-bottle"));
                }
                return;
            }
            maxBottleCount = event.getItem().getAmount();
        }
        if (!player.hasPermission("craftbook.xpstorer.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{com.sk89q.worldedit.util.formatting.text.TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{com.sk89q.worldedit.util.formatting.text.TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        int xp = 0;
        float pcnt = event.getPlayer().getExp();
        int level = event.getPlayer().getLevel();
        event.getPlayer().setExp(0.0f);
        xp += (int)((float)event.getPlayer().getExpToLevel() * pcnt);
        while (event.getPlayer().getLevel() > 0) {
            event.getPlayer().setLevel(event.getPlayer().getLevel() - 1);
            xp += event.getPlayer().getExpToLevel();
        }
        event.getPlayer().setLevel(level);
        event.getPlayer().setExp(pcnt);
        if (xp < this.bottleXpRequirement) {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.xpstorer.insufficient-xp"));
            return;
        }
        int bottleCount = (int)Math.min((double)maxBottleCount, Math.floor((double)xp / (double)this.bottleXpRequirement));
        if (this.requireBottle) {
            event.getItem().subtract(bottleCount);
        }
        for (int tempBottles = bottleCount; tempBottles > 0; tempBottles -= 64) {
            ItemStack bottles = this.createStack(tempBottles);
            event.getClickedBlock().getWorld().dropItemNaturally(LocationUtil.getBlockCentreTop(event.getClickedBlock()), bottles);
        }
        event.getPlayer().setLevel(0);
        event.getPlayer().setExp(0.0f);
        int remainingXP = xp - bottleCount * this.bottleXpRequirement;
        event.getPlayer().giveExp(remainingXP, false);
        player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.xpstorer.success"));
        event.getPlayer().playSound(event.getClickedBlock().getLocation(), Sound.BLOCK_BREWING_STAND_BREW, 1.0f, 1.0f);
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!this.radiusMode || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        Block baseBlock = SignUtil.getBackBlock(event.getBlock());
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[XP]") || !this.block.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)baseBlock.getBlockData()))) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.xpstorer.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError("mech.create-permission");
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        int signRadius = this.maxRadius;
        try {
            signRadius = Math.max(this.maxRadius, Integer.parseInt(PlainTextComponentSerializer.plainText().serialize(event.line(2))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        event.line(1, (Component)Component.text((String)"[XP]"));
        event.line(2, (Component)Component.text((int)signRadius));
        player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.xpstorer.create"));
        ((BukkitSelfTriggerManager)CraftBook.getInstance().getPlatform().getSelfTriggerManager()).registerSelfTrigger(event.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPing(SelfTriggerPingEvent event) {
        if (!this.radiusMode || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        Block baseBlock = SignUtil.getBackBlock(event.getBlock());
        if (!SignUtil.isSign(event.getBlock()) || !this.block.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)baseBlock.getBlockData()))) {
            return;
        }
        Sign sign = (Sign)event.getBlock().getState(false);
        for (Side side : Side.values()) {
            if (!sign.getSide(side).getLine(1).equals("[XP]")) {
                return;
            }
            event.setHandled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThink(SelfTriggerThinkEvent event) {
        int bottleCount;
        if (!EventUtil.passesFilter((Event)event) || !SignUtil.isSign(event.getBlock())) {
            return;
        }
        Sign bukkitSign = (Sign)event.getBlock().getState(false);
        BukkitChangedSign sign = null;
        for (Side side : Side.values()) {
            String line1 = PlainTextComponentSerializer.plainText().serialize(bukkitSign.getSide(side).line(1));
            if (!line1.equals("[XP]")) continue;
            sign = BukkitChangedSign.create(event.getBlock(), side, bukkitSign.getSide(side).lines().toArray(new Component[0]), null);
            break;
        }
        if (sign == null) {
            return;
        }
        event.setHandled(true);
        int signRadius = this.maxRadius;
        try {
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            signRadius = Math.max(this.maxRadius, Integer.parseInt(line2));
        }
        catch (Exception ignored) {
            sign.setLine(2, (Component)Component.text((int)signRadius));
            sign.update(false);
        }
        int xp = 0;
        Block baseBlock = SignUtil.getBackBlock(event.getBlock());
        ArrayList<ItemStack[]> orbs = new ArrayList<ItemStack[]>();
        for (Entity entity : baseBlock.getLocation().getNearbyEntities((double)signRadius, (double)signRadius, (double)signRadius)) {
            if (!(entity instanceof ExperienceOrb)) continue;
            ItemStack[] orb = (ItemStack[])entity;
            if (entity.getTicksLived() <= 20) continue;
            xp += orb.getExperience();
            orbs.add(orb);
        }
        if (xp == 0 || orbs.isEmpty()) {
            return;
        }
        int max = Integer.MAX_VALUE;
        Inventory inventory = null;
        if (this.requireBottle && InventoryUtil.doesBlockHaveInventory(baseBlock.getRelative(BlockFace.UP))) {
            inventory = ((InventoryHolder)baseBlock.getRelative(BlockFace.UP).getState(false)).getInventory();
            max = 0;
            for (ItemStack stack : inventory.getContents()) {
                if (!ItemUtil.isStackValid(stack) || stack.getType() != Material.GLASS_BOTTLE) continue;
                max += stack.getAmount();
            }
        } else if (this.requireBottle) {
            return;
        }
        if (bottleCount == 0) {
            return;
        }
        for (int tempBottles = bottleCount = (int)Math.min((double)max, Math.floor((double)xp / (double)this.bottleXpRequirement)); tempBottles > 0; tempBottles -= 64) {
            ItemStack bottles = this.createStack(tempBottles);
            if (inventory != null) {
                for (ItemStack itemStack : inventory.addItem(new ItemStack[]{bottles}).values()) {
                    event.getBlock().getWorld().dropItemNaturally(LocationUtil.getBlockCentreTop(baseBlock), itemStack);
                }
                continue;
            }
            event.getBlock().getWorld().dropItemNaturally(LocationUtil.getBlockCentreTop(baseBlock), bottles);
        }
        if (this.requireBottle && inventory != null) {
            HashMap leftovers = inventory.removeItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE, bottleCount)});
            for (ItemStack itemStack : leftovers.values()) {
                int amount = itemStack.getAmount();
                for (int i = 0; i < inventory.getContents().length && amount > 0; ++i) {
                    ItemStack content = inventory.getContents()[i];
                    if (!ItemUtil.isStackValid(content) || content.getType() != itemStack.getType()) continue;
                    content.subtract(amount);
                    amount = Math.max(0, amount - content.getAmount());
                }
            }
        }
        int remainingXP = xp - bottleCount * this.bottleXpRequirement;
        for (ExperienceOrb experienceOrb : orbs) {
            if (remainingXP > 0) {
                experienceOrb.setExperience(Math.min(5, remainingXP));
                remainingXP -= 5;
                continue;
            }
            experienceOrb.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThrow(PlayerLaunchProjectileEvent event) {
        if (this.bottleXpOverride < 0 || !(event.getProjectile() instanceof ThrownExpBottle) || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getItemStack().getType() != Material.EXPERIENCE_BOTTLE || !event.getItemStack().hasItemMeta()) {
            return;
        }
        ItemMeta meta = event.getItemStack().getItemMeta();
        if (!meta.getPersistentDataContainer().has(this.xpQuantityKey, PersistentDataType.INTEGER)) {
            return;
        }
        event.getProjectile().getPersistentDataContainer().set(this.xpQuantityKey, PersistentDataType.INTEGER, (Object)((Integer)meta.getPersistentDataContainer().get(this.xpQuantityKey, PersistentDataType.INTEGER)));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onExpBreak(ExpBottleEvent event) {
        if (this.bottleXpOverride < 0 || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        ThrownExpBottle bottle = event.getEntity();
        if (!bottle.getPersistentDataContainer().has(this.xpQuantityKey, PersistentDataType.INTEGER)) {
            return;
        }
        event.setExperience(((Integer)bottle.getPersistentDataContainer().get(this.xpQuantityKey, PersistentDataType.INTEGER)).intValue());
    }
}

