/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanics.TreeLopper;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;

public class BukkitTreeLopper
extends TreeLopper
implements Listener {
    private final Map<Material, Material> blockToSaplings = new HashMap<Material, Material>();
    private final Map<Material, Material> logsToLeaves = new HashMap<Material, Material>();
    private final Map<Material, Material> logsToRoots = new HashMap<Material, Material>();

    public BukkitTreeLopper(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() throws MechanicInitializationException {
        super.enable();
        this.blockToSaplings.clear();
        this.logsToLeaves.clear();
        this.logsToLeaves.put(Material.CRIMSON_STEM, Material.NETHER_WART_BLOCK);
        this.blockToSaplings.put(Material.CRIMSON_STEM, Material.CRIMSON_FUNGUS);
        this.blockToSaplings.put(Material.NETHER_WART_BLOCK, Material.CRIMSON_FUNGUS);
        this.logsToLeaves.put(Material.WARPED_STEM, Material.WARPED_WART_BLOCK);
        this.blockToSaplings.put(Material.WARPED_STEM, Material.WARPED_FUNGUS);
        this.blockToSaplings.put(Material.WARPED_WART_BLOCK, Material.WARPED_FUNGUS);
        this.blockToSaplings.put(Material.MANGROVE_LOG, Material.MANGROVE_PROPAGULE);
        this.blockToSaplings.put(Material.MANGROVE_LEAVES, Material.MANGROVE_PROPAGULE);
        Tag.PLANKS.getValues().stream().map(Material::getKey).map(NamespacedKey::asString).forEach(key -> {
            if (key.endsWith("crimson_planks") || key.endsWith("warped_planks")) {
                return;
            }
            Material sapling = Material.matchMaterial((String)key.replace("planks", "sapling"));
            Material leaves = Material.matchMaterial((String)key.replace("planks", "leaves"));
            Material log = Material.matchMaterial((String)key.replace("planks", "log"));
            Material roots = Material.matchMaterial((String)key.replace("planks", "roots"));
            if (leaves == null && log == null && roots == null) {
                CraftBook.LOGGER.debug("Failed to find any of leaves, roots, or logs for " + key);
                return;
            }
            if (log != null && leaves != null) {
                this.logsToLeaves.put(log, leaves);
            }
            if (log != null && roots != null) {
                this.logsToRoots.put(log, roots);
            }
            if (sapling == null) {
                if (!this.blockToSaplings.containsKey(leaves) && !this.blockToSaplings.containsKey(log)) {
                    CraftBook.LOGGER.debug("Failed to find sapling for " + key);
                }
                return;
            }
            if (log != null) {
                this.blockToSaplings.put(log, sapling);
            }
            if (leaves != null) {
                this.blockToSaplings.put(leaves, sapling);
            }
        });
    }

    @Override
    public void disable() {
        super.disable();
        this.blockToSaplings.clear();
        this.logsToLeaves.clear();
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!this.allowSneaking.doesPass(player.isSneaking())) {
            return;
        }
        if (!Blocks.containsFuzzy((Collection)this.enabledBlocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)event.getBlock().getBlockData()))) {
            return;
        }
        if (!this.enabledItems.contains(player.getItemInHand(HandSide.MAIN_HAND).getType())) {
            return;
        }
        if (!player.hasPermission("craftbook.treelopper.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        Block usedBlock = event.getBlock();
        boolean allowPlanting = player.hasPermission("craftbook.treelopper.sapling");
        this.searchBlock(event.getPlayer(), usedBlock, allowPlanting);
    }

    private static int getMaximumSaplingCount(Material tree) {
        return switch (tree) {
            case Material.DARK_OAK_SAPLING, Material.JUNGLE_SAPLING, Material.PALE_OAK_SAPLING, Material.SPRUCE_SAPLING -> 4;
            default -> 1;
        };
    }

    private static boolean canPlaceOn(Material saplingType, Material blockType) {
        return switch (saplingType) {
            case Material.WARPED_FUNGUS, Material.CRIMSON_FUNGUS -> {
                if (blockType == Material.CRIMSON_NYLIUM || blockType == Material.WARPED_NYLIUM || Tag.DIRT.isTagged((Keyed)blockType)) {
                    yield true;
                }
                yield false;
            }
            default -> Tag.DIRT.isTagged((Keyed)blockType);
        };
    }

    private boolean canBreakBlock(Player player, Material originalBlock, Block toBreak) {
        Material toBreakType = toBreak.getType();
        if (originalBlock != toBreakType) {
            boolean canBreak = false;
            if (this.breakLeaves && this.logsToLeaves.containsKey(originalBlock) && this.logsToLeaves.get(originalBlock) == toBreakType) {
                canBreak = true;
            }
            if (!canBreak && this.breakRoots && this.logsToRoots.containsKey(originalBlock) && this.logsToRoots.get(originalBlock) == toBreakType) {
                canBreak = true;
            }
            if (!canBreak) {
                return false;
            }
        }
        if (!ProtectionUtil.canBreak(player, toBreak)) {
            CraftBookPlugin.inst().wrapPlayer(player).printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            return false;
        }
        return true;
    }

    private void searchBlock(Player player, Block baseBlock, boolean allowPlanting) {
        LinkedList<Block> queue = new LinkedList<Block>();
        HashSet<Location> visitedLocations = new HashSet<Location>();
        int broken = 0;
        int planted = 0;
        Material baseType = baseBlock.getType();
        queue.add(baseBlock);
        while (!queue.isEmpty() && broken < this.maxSearchSize) {
            Block block = (Block)queue.poll();
            if (visitedLocations.contains(block.getLocation()) || !this.canBreakBlock(player, baseType, block)) continue;
            Material currentType = block.getType();
            Material belowBlockType = block.getRelative(0, -1, 0).getType();
            Material saplingType = null;
            if (this.placeSaplings && allowPlanting && this.blockToSaplings.containsKey(currentType)) {
                saplingType = this.blockToSaplings.get(currentType);
            }
            if (saplingType != null && planted < BukkitTreeLopper.getMaximumSaplingCount(saplingType) && BukkitTreeLopper.canPlaceOn(saplingType, belowBlockType)) {
                Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), (Runnable)new SaplingPlanter(block, saplingType), 2L);
                ++planted;
            }
            ItemStack mainHandItem = player.getInventory().getItemInMainHand();
            block.breakNaturally(mainHandItem);
            if (!(this.singleDamageAxe || !this.leavesDamageAxe && Tag.LEAVES.isTagged((Keyed)currentType) || mainHandItem.isEmpty() || !mainHandItem.damage(1, (LivingEntity)player).isEmpty())) {
                return;
            }
            visitedLocations.add(block.getLocation());
            ++broken;
            List<Block> searchBlocks = this.allowDiagonals ? BlockUtil.getIndirectlyTouchingBlocks(block) : BlockUtil.getTouchingBlocks(block);
            for (Block relativeBlock : searchBlocks) {
                if (visitedLocations.contains(relativeBlock.getLocation())) continue;
                queue.add(relativeBlock);
            }
        }
    }

    private record SaplingPlanter(Block location, Material sapling) implements Runnable
    {
        @Override
        public void run() {
            this.location.setType(this.sapling);
        }
    }
}

