/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.math.Position;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.data.Directional;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.Teleporter;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.ParsingUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class BukkitTeleporter
extends Teleporter
implements Listener {
    public BukkitTeleporter(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        String[] pos;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[Teleporter]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.teleporter.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        String posLine = PlainTextComponentSerializer.plainText().serialize(event.line(2));
        if (posLine.length() > 0 && (pos = RegexUtil.COMMA_PATTERN.split(ParsingUtil.parseLine(posLine, (Player)player))).length <= 2) {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.invalid-destination"));
            SignUtil.cancelSignChange(event);
            return;
        }
        player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.create"));
        event.line(1, (Component)Component.text((String)"[Teleporter]"));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (!this.buttonEnabled || event.getHand() != EquipmentSlot.HAND || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!Tag.BUTTONS.isTagged((Keyed)event.getClickedBlock().getType())) {
            return;
        }
        this.onCommonClick(event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        this.onCommonClick(event);
    }

    public void onCommonClick(PlayerInteractEvent event) {
        Block destination;
        if (!EventUtil.passesFilter((Event)event) || event.getHand() != EquipmentSlot.HAND || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        Block block = null;
        BukkitChangedSign sign = null;
        if (SignUtil.isSign(event.getClickedBlock())) {
            Sign bukkitSign = (Sign)event.getClickedBlock().getState(false);
            sign = BukkitChangedSign.create(event.getClickedBlock(), bukkitSign.getInteractableSideFor((Position)event.getInteractionPoint()), bukkitSign.lines().toArray(new Component[0]), localPlayer);
            block = event.getClickedBlock();
        } else if (Tag.BUTTONS.isTagged((Keyed)event.getClickedBlock().getType())) {
            Directional b = (Directional)event.getClickedBlock().getBlockData();
            Block oppositeBlock = event.getClickedBlock().getRelative(b.getFacing().getOppositeFace(), 2);
            if (SignUtil.isSign(oppositeBlock)) {
                Sign bukkitSign = (Sign)oppositeBlock.getState(false);
                for (Side side : Side.values()) {
                    String line1 = PlainTextComponentSerializer.plainText().serialize(bukkitSign.getSide(side).line(1));
                    if (!line1.equals("[Teleporter]")) continue;
                    block = oppositeBlock;
                    sign = BukkitChangedSign.create(block, side, bukkitSign.lines().toArray(new Component[0]), localPlayer);
                    break;
                }
            }
        } else {
            return;
        }
        if (block == null || sign == null) {
            return;
        }
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        if (!line1.equals("[Teleporter]")) {
            return;
        }
        String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
        if (line2.isEmpty()) {
            localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.no-depart"));
            return;
        }
        String[] pos = RegexUtil.COMMA_PATTERN.split(line2);
        if (pos.length <= 2) {
            localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.invalid-destination"));
            return;
        }
        try {
            int x = Integer.parseInt(pos[0]);
            int y = Integer.parseInt(pos[1]);
            int z = Integer.parseInt(pos[2]);
            destination = block.getWorld().getBlockAt(x, y, z);
        }
        catch (NumberFormatException ignored) {
            localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.invalid-destination"));
            return;
        }
        if (this.requireSign) {
            if (!SignUtil.isSign(destination)) {
                localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.no-sign"));
                return;
            }
            Sign bukkitDestSign = (Sign)destination.getState(false);
            boolean found = false;
            for (Side side : Side.values()) {
                if (!bukkitDestSign.getSide(side).getLine(1).equals("[Teleporter]")) continue;
                found = true;
                break;
            }
            if (!found) {
                localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.no-sign"));
                return;
            }
        }
        if (!localPlayer.hasPermission("craftbook.teleporter.use")) {
            event.setCancelled(true);
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), block.getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (this.maxRange > 0 && localPlayer.getLocation().toVector().distanceSq(BukkitAdapter.adapt((Location)destination.getLocation()).toVector()) > (double)(this.maxRange * this.maxRange)) {
            localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.too-far"));
            return;
        }
        this.activateTeleporter(localPlayer, event.getPlayer(), destination);
        event.setCancelled(true);
    }

    private void activateTeleporter(CraftBookPlayer player, org.bukkit.entity.Player bukkitPlayer, Block destination) {
        boolean teleported;
        com.sk89q.worldedit.util.Location floor = BukkitAdapter.adapt((Location)destination.getLocation()).setY((double)(destination.getY() + 1));
        BlockState floorBlock = player.getWorld().getBlock(floor.toVector().toBlockPoint());
        if (floorBlock.getBlockType().getMaterial().isMovementBlocker() && !BlockCategories.SIGNS.contains((BlockStateHolder)floorBlock)) {
            floor = floor.setY(floor.getY() - 1.0);
            floorBlock = player.getWorld().getBlock(floor.toVector().toBlockPoint());
        }
        int foundFree = 0;
        boolean foundGround = false;
        for (int i = 0; i < 5; ++i) {
            if (!floorBlock.getBlockType().getMaterial().isMovementBlocker() || BlockCategories.SIGNS.contains((BlockStateHolder)floorBlock)) {
                ++foundFree;
            } else {
                foundGround = true;
                break;
            }
            if (floor.getY() == 0.0) break;
            floor = floor.setY(floor.getY() - 1.0);
            floorBlock = player.getWorld().getBlock(floor.toVector().toBlockPoint());
        }
        if (!foundGround) {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.no-floor"));
            return;
        }
        if (foundFree < 2) {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.obstructed"));
            return;
        }
        Location newLocation = LocationUtil.getBlockCentreTop(BukkitAdapter.adapt((com.sk89q.worldedit.util.Location)floor).getBlock());
        player.trySetPosition(BukkitAdapter.adapt((Location)newLocation).toVector(), newLocation.getPitch(), newLocation.getYaw());
        boolean bl = teleported = bukkitPlayer.getVehicle() == null ? bukkitPlayer.teleport(newLocation, PlayerTeleportEvent.TeleportCause.PLUGIN, new TeleportFlag[]{TeleportFlag.Relative.VELOCITY_X, TeleportFlag.Relative.VELOCITY_Y, TeleportFlag.Relative.VELOCITY_Z, TeleportFlag.Relative.VELOCITY_ROTATION}) : bukkitPlayer.getVehicle().teleport(newLocation, PlayerTeleportEvent.TeleportCause.PLUGIN);
        if (teleported) {
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.teleported"));
        } else {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.teleporter.obstructed"));
        }
    }
}

