/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.HeightMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.type.Snow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitTask;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.jspecify.annotations.Nullable;

public class BukkitSnow
extends org.enginehub.craftbook.mechanics.Snow
implements Listener {
    private static final BlockFace[] UPDATE_FACES = new BlockFace[]{BlockFace.UP, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private static final BlockFace[] DISPERSE_FACES = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST};
    private @Nullable BukkitTask randomTickTask;
    private @Nullable BukkitTask dispersionTask;
    private @Nullable DispersionQueue dispersionQueueRunner;
    private final Queue<Block> dispersionQueue = new LinkedList<Block>();

    public BukkitSnow(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        if (this.meltSunlight || this.snowPiling) {
            this.randomTickTask = Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), (Runnable)new SnowRandomTicker(), 20L, 20L);
        }
        if (this.dispersionMode) {
            this.dispersionQueueRunner = new DispersionQueue();
            this.dispersionTask = Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), (Runnable)this.dispersionQueueRunner, (long)this.dispersionTickSpeed, (long)this.dispersionTickSpeed);
        }
    }

    @Override
    public void disable() {
        super.disable();
        if (this.randomTickTask != null) {
            this.randomTickTask.cancel();
        }
        if (this.dispersionTask != null) {
            this.dispersionTask.cancel();
            if (this.dispersionQueueRunner != null) {
                while (!this.dispersionQueue.isEmpty()) {
                    this.dispersionQueueRunner.run();
                }
            }
        }
        this.dispersionQueue.clear();
    }

    private boolean isReplacable(Block block) {
        BlockData data = block.getBlockData();
        Material type = data.getMaterial();
        return type != Material.WATER && type != Material.LAVA && (BlockUtil.isBlockReplacable(type) || Blocks.containsFuzzy((Collection)this.dispersionReplacables, (BlockStateHolder)BukkitAdapter.adapt((BlockData)data)));
    }

    private boolean canPlaceAt(Block block) {
        Material type = block.getType();
        if (this.freezeWater && type == Material.WATER) {
            return true;
        }
        return BukkitAdapter.adapt((World)block.getWorld()).canPlaceAt(BukkitAdapter.asBlockVector((Location)block.getLocation()), BlockTypes.SNOW.getDefaultState());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSnowballHit(ProjectileHitEvent event) {
        if (!this.snowballPlacement || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getEntity() instanceof Snowball) {
            ProjectileSource projectileSource;
            Block block = event.getEntity().getLocation().getBlock();
            if (event.getEntity().getShooter() != null && (projectileSource = event.getEntity().getShooter()) instanceof Player) {
                Player shooter = (Player)projectileSource;
                CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(shooter);
                if (!player.hasPermission("craftbook.snow.place")) {
                    return;
                }
                if (!ProtectionUtil.canBuild(shooter, block)) {
                    return;
                }
            }
            this.increaseSnow(block, true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.dispersionMode || event.getBlock().getType() != Material.SNOW || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.addToDispersionQueue(event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.trample && !this.slowdown) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        Block toBlock = event.getTo().getBlock();
        if (toBlock.getType() == Material.SNOW) {
            Snow levelled = (Snow)toBlock.getBlockData();
            if (this.slowdown) {
                if (levelled.getLayers() > 4) {
                    event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 20, 2));
                } else if (levelled.getLayers() > levelled.getMinimumLayers()) {
                    event.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 20, 1));
                }
            }
            if (this.trample) {
                if (this.jumpTrample && !(event.getFrom().getY() - event.getTo().getY() >= 0.1)) {
                    return;
                }
                if (ThreadLocalRandom.current().nextInt(20) == 0) {
                    if (this.partialTrample && levelled.getLayers() == levelled.getMinimumLayers() && toBlock.getRelative(BlockFace.DOWN).getType() != Material.SNOW) {
                        return;
                    }
                    if (!player.hasPermission("craftbook.snow.trample")) {
                        return;
                    }
                    if (!ProtectionUtil.canBreak(event.getPlayer(), event.getPlayer().getLocation().getBlock())) {
                        return;
                    }
                    this.decreaseSnow(toBlock, true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.dispersionMode || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (BlockFace dir : UPDATE_FACES) {
            this.addToDispersionQueue(event.getBlock().getRelative(dir));
        }
    }

    boolean increaseSnow(Block snow, boolean disperse) {
        Snow snowData;
        while (snow.getRelative(BlockFace.DOWN).getType().isAir()) {
            snow = snow.getRelative(BlockFace.DOWN);
        }
        Block below = snow.getRelative(BlockFace.DOWN);
        Material belowType = below.getType();
        if (this.isReplacable(below)) {
            if (belowType != Material.SNOW) {
                return this.increaseSnow(below, disperse);
            }
            snowData = (Snow)below.getBlockData();
            if (snowData.getLayers() < snowData.getMaximumLayers()) {
                return this.increaseSnow(below, disperse);
            }
        }
        if (belowType == Material.WATER) {
            if (this.freezeWater) {
                Levelled waterData = (Levelled)below.getBlockData();
                if (waterData.getLevel() == 0) {
                    BlockState state = below.getState();
                    state.setType(Material.ICE);
                    if (ProtectionUtil.canBlockForm(state.getBlock(), state)) {
                        below.setType(Material.ICE);
                    }
                } else {
                    below.setType(Material.SNOW);
                }
            }
            return true;
        }
        if (snow.getType() != Material.SNOW) {
            if (belowType == Material.SNOW) {
                boolean allowed;
                boolean bl = allowed = this.pileHigh && below.getRelative(BlockFace.DOWN, this.maxPileHeight).getType() != Material.SNOW;
                if (!allowed) {
                    return false;
                }
            }
            if (!this.canPlaceAt(snow) || !this.isReplacable(snow)) {
                return false;
            }
            snow.setType(Material.SNOW);
            if (disperse && belowType == Material.SNOW) {
                this.addToDispersionQueue(snow);
            }
            return true;
        }
        snowData = (Snow)snow.getBlockData();
        if (snowData.getLayers() + 1 > snowData.getMaximumLayers()) {
            if (this.pileHigh && below.getRelative(BlockFace.DOWN, this.maxPileHeight).getType() != Material.SNOW) {
                snowData.setLayers(snowData.getMaximumLayers());
                snow.setBlockData((BlockData)snowData);
                if (disperse) {
                    this.addToDispersionQueue(snow);
                }
                return true;
            }
            return false;
        }
        snowData.setLayers(snowData.getLayers() + 1);
        snow.setBlockData((BlockData)snowData);
        if (disperse) {
            this.addToDispersionQueue(snow);
        }
        return true;
    }

    boolean decreaseSnow(Block snow, boolean disperse) {
        if (snow.getType() != Material.SNOW) {
            return false;
        }
        Block aboveBlock = snow.getRelative(BlockFace.UP);
        if (aboveBlock.getType() == Material.SNOW) {
            return this.decreaseSnow(aboveBlock, disperse);
        }
        Snow snowData = (Snow)snow.getBlockData();
        if (snowData.getLayers() == snowData.getMinimumLayers()) {
            snow.setType(Material.AIR);
        } else {
            snowData.setLayers(snowData.getLayers() - 1);
        }
        snow.setBlockData((BlockData)snowData);
        if (disperse) {
            for (BlockFace dir : UPDATE_FACES) {
                this.addToDispersionQueue(snow.getRelative(dir));
            }
        }
        return true;
    }

    void addToDispersionQueue(Block block) {
        if (!this.dispersionMode) {
            return;
        }
        this.dispersionQueue.offer(block);
    }

    void disperse(Block snow) {
        Material snowType = snow.getType();
        if (snowType != Material.SNOW) {
            return;
        }
        Snow snowData = (Snow)snow.getBlockData();
        if (snowData.getLayers() == snowData.getMinimumLayers()) {
            return;
        }
        Block below = snow.getRelative(BlockFace.DOWN);
        Material belowType = below.getType();
        if (belowType == Material.SNOW) {
            Snow belowData = (Snow)below.getBlockData();
            if (belowData.getLayers() < belowData.getMaximumLayers() && this.decreaseSnow(snow, false)) {
                this.increaseSnow(below, true);
                return;
            }
        } else if (this.isReplacable(below) && this.canPlaceAt(below) && this.decreaseSnow(snow, false)) {
            this.increaseSnow(below, true);
            return;
        }
        if (snowData.getLayers() == snowData.getMaximumLayers() && snow.getRelative(BlockFace.UP).getType() == Material.SNOW) {
            this.disperse(snow.getRelative(BlockFace.UP));
            return;
        }
        BlockFace best = null;
        int bestDiff = 0;
        List<BlockFace> faces = Arrays.asList(DISPERSE_FACES);
        Collections.shuffle(faces);
        for (BlockFace dir : faces) {
            int diff;
            Block block = snow.getRelative(dir);
            Block relativeBelow = block.getRelative(BlockFace.DOWN);
            if (!this.isReplacable(block) || !this.canPlaceAt(block) && !this.isReplacable(relativeBelow)) continue;
            Material blockType = block.getType();
            if (blockType == Material.SNOW) {
                Snow blockData = (Snow)block.getBlockData();
                if (snowData.getLayers() <= blockData.getLayers() + 1) continue;
                diff = snowData.getLayers() - blockData.getLayers();
            } else {
                int n = diff = blockType.isAir() ? 100 : 99;
            }
            if (diff <= bestDiff) continue;
            best = dir;
            bestDiff = diff;
        }
        if (best != null) {
            Block block = snow.getRelative(best);
            if (this.decreaseSnow(snow, false)) {
                this.increaseSnow(block, true);
            }
        }
    }

    private class SnowRandomTicker
    implements Runnable {
        private SnowRandomTicker() {
        }

        @Override
        public void run() {
            if (Bukkit.getServer().isPaused()) {
                return;
            }
            for (World world : Bukkit.getWorlds()) {
                boolean meltMode;
                boolean bl = meltMode = !world.hasStorm();
                if (meltMode && !BukkitSnow.this.meltSunlight) continue;
                for (Chunk chunk : world.getLoadedChunks()) {
                    int blockX = (chunk.getX() << 4) + ThreadLocalRandom.current().nextInt(16);
                    int blockZ = (chunk.getZ() << 4) + ThreadLocalRandom.current().nextInt(16);
                    Block block = world.getHighestBlockAt(blockX, blockZ, HeightMap.MOTION_BLOCKING);
                    Material type = block.getType();
                    double temperature = block.getTemperature();
                    Block above = block.getRelative(BlockFace.UP);
                    Material aboveType = above.getType();
                    double aboveTemperature = above.getTemperature();
                    if (type == Material.ICE && aboveType != Material.SNOW && meltMode && temperature > 0.05) {
                        block.setType(Material.WATER);
                        continue;
                    }
                    if (aboveType != Material.SNOW) continue;
                    if (meltMode) {
                        if (BukkitSnow.this.meltPartial) {
                            Snow snowBlock = (Snow)above.getBlockData();
                            if (aboveTemperature <= 0.05 && snowBlock.getLayers() == snowBlock.getMinimumLayers() && type != Material.SNOW) continue;
                        }
                        BukkitSnow.this.decreaseSnow(above, false);
                        continue;
                    }
                    if (!(aboveTemperature <= 0.15)) continue;
                    BukkitSnow.this.increaseSnow(above, true);
                }
            }
        }
    }

    private class DispersionQueue
    implements Runnable {
        private DispersionQueue() {
        }

        @Override
        public void run() {
            if (Bukkit.getServer().isPaused()) {
                return;
            }
            int limit = 10000;
            int iterations = Math.min(limit, BukkitSnow.this.dispersionQueue.size());
            for (int i = 0; i < iterations; ++i) {
                Block block = BukkitSnow.this.dispersionQueue.poll();
                if (block == null) {
                    return;
                }
                BukkitSnow.this.disperse(block);
            }
        }
    }
}

