/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.RedstoneGlowstone;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitRedstoneGlowstone
extends RedstoneGlowstone
implements Listener {
    public BukkitRedstoneGlowstone(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        boolean currentState;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        Material type = event.getBlock().getType();
        if (type != Material.GLOWSTONE && !this.offBlock.equalsFuzzy((BlockStateHolder)BukkitAdapter.adapt((BlockData)event.getBlock().getBlockData()))) {
            return;
        }
        boolean bl = currentState = type == Material.GLOWSTONE;
        if (event.isOn() == currentState) {
            return;
        }
        this.setPowered(event.getBlock(), event.isOn());
    }

    private void setPowered(Block block, boolean state) {
        if (state) {
            block.setType(Material.GLOWSTONE);
        } else {
            block.setBlockData(BukkitAdapter.adapt((BlockStateHolder)this.offBlock));
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.preventBreaking || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getBlock().getType() == Material.GLOWSTONE && (event.getBlock().isBlockIndirectlyPowered() || event.getBlock().isBlockPowered())) {
            event.setCancelled(true);
        }
    }
}

