/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.RedstoneFire;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitRedstoneFire
extends RedstoneFire
implements Listener {
    public BukkitRedstoneFire(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        BlockType type = BukkitAdapter.asBlockType((Material)event.getBlock().getType());
        if (!this.doesAffectBlock(type)) {
            return;
        }
        Block above = event.getBlock().getRelative(BlockFace.UP);
        Material aboveType = above.getType();
        if (event.isOn() && BlockUtil.isBlockReplacable(aboveType)) {
            above.setType(BukkitAdapter.adapt((BlockType)this.getFireForBlock(type)));
        } else if (!(event.isOn() || aboveType != Material.FIRE && aboveType != Material.SOUL_FIRE)) {
            above.setType(Material.AIR);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLeftClick(PlayerInteractEvent event) {
        Block fire;
        Material fireMaterial;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        BlockType type = BukkitAdapter.asBlockType((Material)event.getClickedBlock().getType());
        if (!this.doesAffectBlock(type)) {
            return;
        }
        if (event.getBlockFace() == BlockFace.UP && ((fireMaterial = (fire = event.getClickedBlock().getRelative(event.getBlockFace())).getType()) == Material.FIRE || fireMaterial == Material.SOUL_FIRE) && fire.getRelative(BlockFace.DOWN).isBlockPowered()) {
            event.setCancelled(true);
        }
    }
}

