/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.List;
import java.util.UUID;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanic.exception.MechanicInitializationException;
import org.enginehub.craftbook.mechanics.PaintingSwitcher;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.jspecify.annotations.Nullable;

public class BukkitPaintingSwitcher
extends PaintingSwitcher
implements Listener {
    private final BiMap<UUID, Painting> paintingMap = HashBiMap.create();
    private @Nullable List<NamespacedKey> artKeys;

    public BukkitPaintingSwitcher(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() throws MechanicInitializationException {
        super.enable();
        Registry paintingRegistry = RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT);
        this.artKeys = paintingRegistry.stream().map(arg_0 -> ((Registry)paintingRegistry).getKey(arg_0)).toList();
    }

    @Override
    public void disable() {
        super.disable();
        this.paintingMap.clear();
        this.artKeys = null;
    }

    public boolean isBeingEdited(Painting painting) {
        UUID playerUuid = (UUID)this.paintingMap.inverse().get((Object)painting);
        if (playerUuid != null && this.paintingMap.get((Object)playerUuid) != null) {
            Player player = Bukkit.getPlayer((UUID)playerUuid);
            return player != null && LocationUtil.isWithinSphericalRadius(painting.getLocation(), player.getLocation(), (double)this.modifyRange);
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Entity entity;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getHand() == EquipmentSlot.HAND && (entity = event.getRightClicked()) instanceof Painting) {
            Painting paint = (Painting)entity;
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
            if (!player.hasPermission("craftbook.paintingswitcher.use")) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                }
                return;
            }
            if (!ProtectionUtil.canBuild(event.getPlayer(), paint.getLocation().getBlock())) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                }
                return;
            }
            if (!this.isBeingEdited(paint)) {
                this.paintingMap.put((Object)player.getUniqueId(), (Object)paint);
                player.printInfo((Component)TranslatableComponent.of((String)"craftbook.paintingswitcher.now-editing"));
            } else if (((UUID)this.paintingMap.inverse().get((Object)paint)).equals(player.getUniqueId())) {
                this.paintingMap.remove((Object)player.getUniqueId());
                player.printInfo((Component)TranslatableComponent.of((String)"craftbook.paintingswitcher.no-longer-editing"));
            } else if (this.isBeingEdited(paint)) {
                Player otherPlayer = Bukkit.getPlayer((UUID)((UUID)this.paintingMap.inverse().get((Object)paint)));
                if (otherPlayer != null) {
                    player.printError((Component)TranslatableComponent.of((String)"craftbook.paintingswitcher.in-use", (Component[])new Component[]{TextComponent.of((String)otherPlayer.getName())}));
                }
            } else {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onHeldItemChange(PlayerItemHeldEvent event) {
        boolean isForwards;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!this.paintingMap.containsKey((Object)player.getUniqueId())) {
            return;
        }
        if (!player.hasPermission("craftbook.paintingswitcher.use")) {
            return;
        }
        if (event.getNewSlot() > event.getPreviousSlot()) {
            isForwards = true;
        } else if (event.getNewSlot() < event.getPreviousSlot()) {
            isForwards = false;
        } else {
            return;
        }
        if (event.getPreviousSlot() == 0 && event.getNewSlot() == 8) {
            isForwards = false;
        } else if (event.getPreviousSlot() == 8 && event.getNewSlot() == 0) {
            isForwards = true;
        }
        Painting paint = (Painting)this.paintingMap.get((Object)player.getUniqueId());
        if (!paint.isValid()) {
            this.paintingMap.remove((Object)player.getUniqueId());
            return;
        }
        if (!LocationUtil.isWithinSphericalRadius(paint.getLocation(), event.getPlayer().getLocation(), (double)this.modifyRange)) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.paintingswitcher.too-far-away"));
            this.paintingMap.remove((Object)event.getPlayer().getUniqueId());
            return;
        }
        Registry paintingRegistry = RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT);
        int newID = this.artKeys.indexOf(paintingRegistry.getKey((Keyed)paint.getArt())) + (isForwards ? 1 : -1);
        if (newID < 0) {
            newID = this.artKeys.size() - 1;
        } else if (newID > this.artKeys.size() - 1) {
            newID = 0;
        }
        while (!paint.setArt((Art)paintingRegistry.get(this.artKeys.get(newID)))) {
            if (newID > 0 && !isForwards) {
                --newID;
                continue;
            }
            if (newID >= this.artKeys.size() - 1 || !isForwards) break;
            ++newID;
        }
        this.paintingMap.put((Object)player.getUniqueId(), (Object)paint);
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.paintingMap.remove((Object)event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onKicked(PlayerKickEvent event) {
        this.paintingMap.remove((Object)event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onHangingEntityDestroy(HangingBreakByEntityEvent event) {
        Hanging hanging = event.getEntity();
        if (hanging instanceof Painting) {
            Player player;
            Painting painting = (Painting)hanging;
            UUID uuid = (UUID)this.paintingMap.inverse().remove((Object)painting);
            if (uuid != null && (player = Bukkit.getPlayer((UUID)uuid)) != null) {
                CraftBookPlugin.inst().wrapPlayer(player).printInfo((Component)TranslatableComponent.of((String)"craftbook.paintingswitcher.no-longer-editing"));
            }
        }
    }
}

