/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.Marquee;
import org.enginehub.craftbook.mechanics.variables.VariableKey;
import org.enginehub.craftbook.mechanics.variables.VariableManager;
import org.enginehub.craftbook.mechanics.variables.exception.VariableException;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.enginehub.craftbook.util.persistence.OwnedSignHelper;

public class BukkitMarquee
extends Marquee
implements Listener {
    public BukkitMarquee(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSignClick(SignClickEvent event) {
        VariableKey variableKey;
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        BukkitChangedSign sign = event.getSign();
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        if (!line1.equals("[Marquee]")) {
            return;
        }
        CraftBookPlayer lplayer = event.getWrappedPlayer();
        if (!lplayer.hasPermission("craftbook.marquee.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        try {
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            variableKey = VariableKey.of(line3, line2, OwnedSignHelper.getOwner((BlockState)sign.getSign()));
        }
        catch (VariableException e) {
            lplayer.printError(e.getRichMessage());
            event.setCancelled(true);
            return;
        }
        String var = VariableManager.instance.getVariable(variableKey);
        if (var == null) {
            lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.variables.unknown-variable", (Component[])new Component[]{TextComponent.of((String)variableKey.toString())}));
        } else {
            lplayer.printInfo((Component)TextComponent.of((String)var));
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        VariableKey variableKey;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.getLine(1).equalsIgnoreCase("[marquee]")) {
            return;
        }
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!lplayer.hasPermission("craftbook.marquee.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        try {
            variableKey = VariableKey.of(event.getLine(3), event.getLine(2), (Actor)lplayer);
        }
        catch (VariableException e) {
            lplayer.printError(e.getRichMessage());
            SignUtil.cancelSignChange(event);
            return;
        }
        if (!variableKey.hasPermission((Actor)lplayer, "get")) {
            lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.variables.no-permission", (Component[])new Component[]{TextComponent.of((String)variableKey.toString())}));
            SignUtil.cancelSignChange(event);
            return;
        }
        String var = VariableManager.instance.getVariable(variableKey);
        if (var == null) {
            lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.variables.unknown-variable", (Component[])new Component[]{TextComponent.of((String)variableKey.toString())}));
            SignUtil.cancelSignChange(event);
            return;
        }
        event.setLine(1, "[Marquee]");
        lplayer.printInfo((Component)TranslatableComponent.of((String)"craftbook.marquee.create"));
        Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
            if (!SignUtil.isSign(event.getBlock())) {
                return;
            }
            Sign sign = (Sign)event.getBlock().getState(false);
            if (!sign.getSide(event.getSide()).getLine(1).equals("[Marquee]")) {
                return;
            }
            OwnedSignHelper.setOwner((TileState)sign, lplayer.getUniqueId());
        });
    }
}

