/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.LightSwitch;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;

public class BukkitLightSwitch
extends LightSwitch
implements Listener {
    public BukkitLightSwitch(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[i]") && !signLine1.equalsIgnoreCase("[|]")) {
            return;
        }
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!lplayer.hasPermission("craftbook.lightswitch.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        event.line(1, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.text((String)"[I]"));
        lplayer.printInfo((Component)TranslatableComponent.of((String)"craftbook.lightswitch.create"));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        BukkitChangedSign sign = event.getSign();
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        if (!line1.equals("[I]")) {
            return;
        }
        CraftBookPlayer player = event.getWrappedPlayer();
        if (!player.hasPermission("craftbook.lightswitch.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        this.toggleLights(sign);
        event.setCancelled(true);
    }

    private void toggleLights(BukkitChangedSign sign) {
        int maximum;
        int radius;
        try {
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            radius = Math.min(Integer.parseInt(line2), this.maxRange);
        }
        catch (Exception ignored) {
            radius = Math.min(10, this.maxRange);
        }
        try {
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
            maximum = Math.min(Integer.parseInt(line3), this.maxLights);
        }
        catch (Exception ignored) {
            maximum = Math.min(this.maxLights, 20);
        }
        int wx = sign.getX();
        int wy = sign.getY();
        int wz = sign.getZ();
        Material aboveID = sign.getBlock().getRelative(0, 1, 0).getType();
        if (aboveID == Material.WALL_TORCH || aboveID == Material.REDSTONE_WALL_TORCH) {
            boolean on = aboveID != Material.WALL_TORCH;
            int changed = 0;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        Block relBlock;
                        Material id;
                        if (x == 0 && y == 0 && z == 0 || (id = (relBlock = sign.getBlock().getWorld().getBlockAt(x + wx, y + wy, z + wz)).getType()) != Material.TORCH && id != Material.WALL_TORCH && id != Material.REDSTONE_TORCH && id != Material.REDSTONE_WALL_TORCH) continue;
                        if (changed >= maximum) {
                            return;
                        }
                        if (id == Material.WALL_TORCH || id == Material.REDSTONE_WALL_TORCH) {
                            Directional currentData = (Directional)relBlock.getBlockData();
                            Directional directional = (Directional)(on ? Material.WALL_TORCH : Material.REDSTONE_WALL_TORCH).createBlockData();
                            directional.setFacing(currentData.getFacing());
                            relBlock.setBlockData((BlockData)directional, false);
                        } else {
                            relBlock.setType(on ? Material.TORCH : Material.REDSTONE_TORCH, false);
                        }
                        ++changed;
                    }
                }
            }
        }
    }
}

