/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.LightStone;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;

public class BukkitLightStone
extends LightStone
implements Listener {
    public BukkitLightStone(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onRightClick(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() == null || block == null) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        BaseItemStack heldItem = player.getItemInHand(event.getHand() == EquipmentSlot.HAND ? HandSide.MAIN_HAND : HandSide.OFF_HAND);
        if (heldItem.getType() != this.item) {
            return;
        }
        if (!player.hasPermission("craftbook.lightstone.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        block = event.getClickedBlock().getRelative(event.getBlockFace());
        Component component = TranslatableComponent.of((String)"craftbook.lightstone.line", (Component[])new Component[]{this.getCurrentLine(block.getLightLevel()), TextComponent.of((int)block.getLightLevel(), (TextColor)TextColor.YELLOW)}).color(TextColor.YELLOW);
        if (this.actionBar) {
            player.printActionBar(component);
        } else {
            player.print(component);
        }
        event.setCancelled(true);
    }
}

