/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.JackOLantern;
import org.enginehub.craftbook.util.EventUtil;

public class BukkitJackOLantern
extends JackOLantern
implements Listener {
    public BukkitJackOLantern(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        boolean currentState;
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.isMinor()) {
            return;
        }
        Material type = event.getBlock().getType();
        if (type != Material.CARVED_PUMPKIN && type != Material.JACK_O_LANTERN) {
            return;
        }
        boolean bl = currentState = type == Material.JACK_O_LANTERN;
        if (event.isOn() == currentState) {
            return;
        }
        BukkitJackOLantern.setPowered(event.getBlock(), event.isOn());
    }

    private static void setPowered(Block block, boolean on) {
        BlockFace data = ((Directional)block.getBlockData()).getFacing();
        block.setType(on ? Material.JACK_O_LANTERN : Material.CARVED_PUMPKIN);
        Directional directional = (Directional)block.getBlockData();
        directional.setFacing(data);
        block.setBlockData((BlockData)directional);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.preventBreaking || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getBlock().getType() == Material.JACK_O_LANTERN && (event.getBlock().isBlockIndirectlyPowered() || event.getBlock().isBlockPowered())) {
            event.setCancelled(true);
        }
    }
}

