/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.util.ArrayList;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Powerable;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.HiddenSwitch;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;

public class BukkitHiddenSwitch
extends HiddenSwitch
implements Listener {
    public BukkitHiddenSwitch(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String line1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!line1.equalsIgnoreCase("[x]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.hiddenswitch.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        event.line(1, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.text((String)"[X]"));
        player.printInfo((Component)TranslatableComponent.of((String)"craftbook.hiddenswitch.create"));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.getHand() != EquipmentSlot.HAND || !event.getBlockFace().isCartesian() || event.getPlayer().isSneaking()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.hiddenswitch.use")) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        if (this.testBlock(clickedBlock, event.getBlockFace(), event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    public boolean testBlock(Block switchBlock, BlockFace eventFace, Player player) {
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(player);
        BukkitChangedSign sign = null;
        Block testBlock = null;
        if (this.allowAnyFace) {
            for (BlockFace face : LocationUtil.getDirectFaces()) {
                testBlock = switchBlock.getRelative(face);
                if (!SignUtil.isWallSign(testBlock) || ((WallSign)testBlock.getBlockData()).getFacing() != face) continue;
                sign = BukkitChangedSign.create(testBlock, Side.FRONT);
                break;
            }
        } else {
            BlockFace face = eventFace.getOppositeFace();
            testBlock = switchBlock.getRelative(face);
            if (SignUtil.isWallSign(testBlock) && ((WallSign)testBlock.getBlockData()).getFacing() == face) {
                sign = BukkitChangedSign.create(testBlock, Side.FRONT);
            }
        }
        if (sign == null) {
            return false;
        }
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        if (line1.equalsIgnoreCase("[X]")) {
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            if (!line2.trim().isEmpty() && !CraftBookPlugin.inst().inGroup(player, line2.trim())) {
                lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.hiddenswitch.not-in-group"));
                return true;
            }
            if (!ProtectionUtil.canUse(player, switchBlock.getLocation(), eventFace, Action.RIGHT_CLICK_BLOCK)) {
                return false;
            }
            if (this.toggleSwitches(testBlock, eventFace.getOppositeFace())) {
                lplayer.printInfo((Component)TranslatableComponent.of((String)"craftbook.hiddenswitch.toggle"));
                return true;
            }
        }
        return false;
    }

    private boolean toggleSwitches(Block sign, BlockFace direction) {
        ArrayList<BlockFace> checkFaces = new ArrayList<BlockFace>(4);
        checkFaces.add(BlockFace.UP);
        checkFaces.add(BlockFace.DOWN);
        switch (direction) {
            case EAST: 
            case WEST: {
                checkFaces.add(BlockFace.NORTH);
                checkFaces.add(BlockFace.SOUTH);
                break;
            }
            default: {
                checkFaces.add(BlockFace.EAST);
                checkFaces.add(BlockFace.WEST);
            }
        }
        boolean toggledSwitch = false;
        for (BlockFace blockFace : checkFaces) {
            Block checkBlock = sign.getRelative(blockFace);
            Material checkBlockType = checkBlock.getType();
            if (checkBlockType == Material.LEVER) {
                Powerable powerable;
                powerable.setPowered(!(powerable = (Powerable)checkBlock.getBlockData()).isPowered());
                checkBlock.setBlockData((BlockData)powerable);
                toggledSwitch = true;
                break;
            }
            if (!Tag.BUTTONS.getValues().contains(checkBlockType)) continue;
            Powerable powerable = (Powerable)checkBlock.getBlockData();
            powerable.setPowered(true);
            checkBlock.setBlockData((BlockData)powerable);
            powerable.setPowered(false);
            Runnable turnOff = () -> {
                if (checkBlock.getType() == checkBlockType) {
                    checkBlock.setBlockData((BlockData)powerable);
                }
            };
            Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), turnOff, Tag.WOODEN_BUTTONS.getValues().contains(checkBlockType) ? 30L : 20L);
            toggledSwitch = true;
            break;
        }
        return toggledSwitch;
    }
}

