/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.formatting.text.format.TextColor;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import io.papermc.paper.entity.TeleportFlag;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Switch;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.Elevator;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.jspecify.annotations.Nullable;

public class BukkitElevator
extends Elevator
implements Listener {
    public BukkitElevator(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Elevator.LiftType dir = Elevator.LiftType.fromLabel(PlainTextComponentSerializer.plainText().serialize(event.line(1)));
        if (dir == null) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.elevator.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)("craftbook.elevator.create." + dir.name().toLowerCase(Locale.ROOT))));
        event.line(1, (Component)Component.text((String)dir.getLabel()));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.elevatorAllowRedstone || event.isMinor() || !event.isOn()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Elevator.LiftType dir = this.findLift(event.getBlock());
        if (dir != Elevator.LiftType.UP && dir != Elevator.LiftType.DOWN) {
            return;
        }
        BlockFace shift = dir == Elevator.LiftType.UP ? BlockFace.UP : BlockFace.DOWN;
        Block destination = this.findDestination(shift, event.getBlock());
        if (destination == null) {
            return;
        }
        for (Player player : event.getBlock().getLocation().getNearbyPlayers((double)this.elevatorRedstoneRadius)) {
            CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(player);
            if (!localPlayer.hasPermission("craftbook.elevator.use")) {
                if (!CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) continue;
                localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                continue;
            }
            this.activateElevator(localPlayer, player, destination, shift);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (!this.elevatorButtonEnabled || event.getHand() != EquipmentSlot.HAND || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null || !Tag.BUTTONS.isTagged((Keyed)clickedBlock.getType())) {
            return;
        }
        this.onCommonClick(event);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        this.onCommonClick(event);
    }

    public void onCommonClick(PlayerInteractEvent event) {
        BlockFace shift;
        if (!EventUtil.passesFilter((Event)event) || event.getHand() != EquipmentSlot.HAND || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        CraftBookPlayer localPlayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        Block block = event.getClickedBlock();
        Elevator.LiftType dir = this.findLift(block);
        if (dir == null) {
            return;
        }
        switch (dir) {
            case UP: {
                shift = BlockFace.UP;
                break;
            }
            case DOWN: {
                shift = BlockFace.DOWN;
                break;
            }
            case BOTH: {
                if (event.getInteractionPoint() != null) {
                    double relativeHeight = event.getInteractionPoint().getY();
                    double fractionalPart = relativeHeight - Math.floor(relativeHeight);
                    if (relativeHeight < 0.0) {
                        shift = (fractionalPart = 1.0 - fractionalPart) >= 0.5 ? BlockFace.DOWN : BlockFace.UP;
                        break;
                    }
                    shift = fractionalPart >= 0.5 ? BlockFace.UP : BlockFace.DOWN;
                    break;
                }
                return;
            }
            case RECV: {
                localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.elevator.no-depart"));
                return;
            }
            default: {
                return;
            }
        }
        Block destination = this.findDestination(shift, block);
        if (destination == null) {
            localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.elevator.no-destination"));
            return;
        }
        if (!localPlayer.hasPermission("craftbook.elevator.use")) {
            event.setCancelled(true);
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), block.getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                localPlayer.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        this.activateElevator(localPlayer, event.getPlayer(), destination, shift);
        event.setCancelled(true);
    }

    public @Nullable Block findDestination(BlockFace shift, Block clickedBlock) {
        Elevator.LiftType destinationLiftType;
        int maximumSearchPoint = shift == BlockFace.UP ? clickedBlock.getWorld().getMaxHeight() : clickedBlock.getWorld().getMinHeight();
        Block destination = clickedBlock;
        if (destination.getY() == maximumSearchPoint) {
            return null;
        }
        while ((destinationLiftType = this.findLift(destination = destination.getRelative(shift))) == null || !BukkitElevator.isValidLift(clickedBlock, destination)) {
            if (destination.getY() == clickedBlock.getY()) {
                return null;
            }
            if (destination.getY() != maximumSearchPoint) continue;
            if (this.elevatorLoop) {
                Location temporaryLocation = destination.getLocation();
                temporaryLocation.setY(shift == BlockFace.UP ? (double)clickedBlock.getWorld().getMinHeight() : (double)clickedBlock.getWorld().getMaxHeight());
                destination = temporaryLocation.getBlock();
                continue;
            }
            return null;
        }
        return destination;
    }

    private void activateElevator(CraftBookPlayer player, Player bukkitPlayer, Block destination, BlockFace shift) {
        boolean teleported;
        com.sk89q.worldedit.util.Location floor = player.getLocation().setY((double)(destination.getY() + 1));
        BlockState floorBlock = player.getWorld().getBlock(floor.toVector().toBlockPoint());
        if (floorBlock.getBlockType().getMaterial().isMovementBlocker() && !BlockCategories.SIGNS.contains((BlockStateHolder)floorBlock)) {
            floor = floor.setY(floor.getY() - 1.0);
            floorBlock = player.getWorld().getBlock(floor.toVector().toBlockPoint());
        }
        int foundFree = 0;
        boolean foundGround = false;
        for (int i = 0; i < 5; ++i) {
            if (!floorBlock.getBlockType().getMaterial().isMovementBlocker() || BlockCategories.SIGNS.contains((BlockStateHolder)floorBlock)) {
                ++foundFree;
            } else {
                foundGround = true;
                break;
            }
            if (floor.getY() == (double)player.getWorld().getMinY()) break;
            floor = floor.setY(floor.getY() - 1.0);
            floorBlock = player.getWorld().getBlock(floor.toVector().toBlockPoint());
        }
        if (!foundGround) {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.elevator.no-floor"));
            return;
        }
        if (foundFree < 2) {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.elevator.obstructed"));
            return;
        }
        Location newLocation = bukkitPlayer.getLocation();
        newLocation.setY((double)(floor.getBlockY() + 1));
        boolean bl = teleported = bukkitPlayer.getVehicle() == null ? bukkitPlayer.teleport(newLocation, PlayerTeleportEvent.TeleportCause.PLUGIN, new TeleportFlag[]{TeleportFlag.Relative.VELOCITY_X, TeleportFlag.Relative.VELOCITY_Y, TeleportFlag.Relative.VELOCITY_Z, TeleportFlag.Relative.VELOCITY_ROTATION}) : bukkitPlayer.getVehicle().teleport(newLocation, PlayerTeleportEvent.TeleportCause.PLUGIN);
        if (teleported) {
            BukkitElevator.teleportFinish(player, destination, shift);
        } else {
            player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.elevator.obstructed"));
        }
    }

    public static void teleportFinish(CraftBookPlayer player, Block destination, BlockFace shift) {
        BukkitChangedSign destinationSign = null;
        if (!SignUtil.isSign(destination)) {
            Switch attachable;
            BlockData blockData;
            if (Tag.BUTTONS.isTagged((Keyed)destination.getType()) && (blockData = destination.getBlockData()) instanceof Switch && SignUtil.isSign(destination.getRelative((attachable = (Switch)blockData).getFacing().getOppositeFace(), 2))) {
                Sign sign = (Sign)destination.getRelative(attachable.getFacing().getOppositeFace(), 2).getState(false);
                for (Side side : Side.values()) {
                    if (Elevator.LiftType.fromLabel(sign.getSide(side).getLine(1)) == null) continue;
                    destinationSign = BukkitChangedSign.create(sign, side);
                    break;
                }
            }
        } else {
            Sign sign = (Sign)destination.getState(false);
            for (Side side : Side.values()) {
                if (Elevator.LiftType.fromLabel(sign.getSide(side).getLine(1)) == null) continue;
                destinationSign = BukkitChangedSign.create(sign, side);
                break;
            }
        }
        if (destinationSign == null) {
            return;
        }
        String title = PlainTextComponentSerializer.plainText().serialize(destinationSign.getLine(0));
        if (!title.isEmpty()) {
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.elevator.floor-notice", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)title, (TextColor)TextColor.WHITE)}));
        } else {
            player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)(shift.getModY() > 0 ? "craftbook.elevator.moved-up" : "craftbook.elevator.moved-down")));
        }
    }

    public static boolean isValidLift(Block start, Block stop) {
        if (!SignUtil.isSign(start) || !SignUtil.isSign(stop)) {
            return true;
        }
        Sign startSign = (Sign)start.getState(false);
        for (Side side : Side.values()) {
            if (!startSign.getSide(side).getLine(2).toLowerCase(Locale.ROOT).startsWith("to:")) continue;
            Sign stopSign = (Sign)stop.getState(false);
            try {
                return stopSign.getSide(side).getLine(0).equalsIgnoreCase(RegexUtil.COLON_PATTERN.split(startSign.getSide(side).getLine(2))[0].trim());
            }
            catch (Exception e) {
                startSign.getSide(side).line(2, (Component)Component.text((String)""));
                return false;
            }
        }
        return true;
    }

    private @Nullable Elevator.LiftType findLift(@Nullable Block block) {
        if (block == null) {
            return null;
        }
        if (!SignUtil.isSign(block)) {
            Switch b;
            Block opposite;
            if (this.elevatorButtonEnabled && Tag.BUTTONS.isTagged((Keyed)block.getType()) && SignUtil.isSign(opposite = block.getRelative((b = (Switch)block.getBlockData()).getFacing().getOppositeFace(), 2))) {
                Sign sign = (Sign)opposite.getState(false);
                for (Side side : Side.values()) {
                    Elevator.LiftType type = Elevator.LiftType.fromLabel(sign.getSide(side).getLine(1));
                    if (type == null) continue;
                    return type;
                }
            }
            return null;
        }
        Sign sign = (Sign)block.getState(false);
        for (Side side : Side.values()) {
            Elevator.LiftType type = Elevator.LiftType.fromLabel(sign.getSide(side).getLine(1));
            if (type == null) continue;
            return type;
        }
        return null;
    }
}

