/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import io.papermc.paper.math.Position;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SelfTriggerPingEvent;
import org.enginehub.craftbook.bukkit.events.SelfTriggerThinkEvent;
import org.enginehub.craftbook.bukkit.events.SelfTriggerUnregisterEvent;
import org.enginehub.craftbook.bukkit.events.SignClickEvent;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.bukkit.st.BukkitSelfTriggerManager;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.CookingPot;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.ItemUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;

public class BukkitCookingPot
extends CookingPot
implements Listener {
    public BukkitCookingPot(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[Cook]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.cookingpot.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        event.line(1, (Component)Component.text((String)"[Cook]"));
        event.line(2, (Component)Component.text((String)"0"));
        event.line(3, (Component)Component.text((String)(this.requireFuel ? "0" : "1")));
        player.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.cookingpot.create"));
        ((BukkitSelfTriggerManager)CraftBook.getInstance().getPlatform().getSelfTriggerManager()).registerSelfTrigger(event.getBlock().getLocation());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPing(SelfTriggerPingEvent event) {
        if (!EventUtil.passesFilter((Event)event) || !SignUtil.isSign(event.getBlock())) {
            return;
        }
        Sign sign = (Sign)event.getBlock().getState(false);
        for (Side side : Side.values()) {
            if (!sign.getSide(side).getLine(1).equals("[Cook]")) continue;
            event.setHandled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onThink(SelfTriggerThinkEvent event) {
        if (!EventUtil.passesFilter((Event)event) || !SignUtil.isSign(event.getBlock())) {
            return;
        }
        BukkitChangedSign sign = null;
        Sign bukkitSign = (Sign)event.getBlock().getState(false);
        for (Side side : Side.values()) {
            if (!bukkitSign.getSide(side).getLine(1).equals("[Cook]")) continue;
            sign = BukkitChangedSign.create(bukkitSign, side, null);
            break;
        }
        if (sign == null) {
            return;
        }
        event.setHandled(true);
        String line0 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(0));
        if (this.emptyCooldown && line0.equals("COOLDOWN")) {
            if (ThreadLocalRandom.current().nextInt(100) != 0) {
                return;
            }
            sign.setLine(0, (Component)Component.text((String)""));
            sign.update(false);
        }
        int currentCookProgress = 0;
        try {
            String line2 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(2));
            currentCookProgress = Math.max(0, Integer.parseInt(line2));
        }
        catch (Exception e) {
            sign.setLine(2, (Component)Component.text((int)0));
        }
        int previousCookProgress = currentCookProgress;
        Block b = SignUtil.getBackBlock(event.getBlock());
        Block cb = b.getRelative(0, 2, 0);
        if (cb.getType() == Material.CHEST) {
            Material fireType = b.getRelative(0, 1, 0).getType();
            if (Tag.FIRE.isTagged((Keyed)fireType) || Tag.CAMPFIRES.isTagged((Keyed)fireType)) {
                Chest chest = (Chest)cb.getState(false);
                Inventory inventory = chest.getInventory();
                List<ItemStack> items = this.allowSmelting ? ItemUtil.getRawMaterials(inventory) : ItemUtil.getRawFood(inventory);
                if (items.isEmpty()) {
                    if (this.emptyCooldown) {
                        sign.setLine(0, (Component)Component.text((String)"COOLDOWN"));
                        sign.update(false);
                    }
                    return;
                }
                int fuelLevel = this.getFuelLevel(sign);
                if (fuelLevel > 0) {
                    currentCookProgress += this.progressPerFuel * Math.min(this.fuelPerTick, fuelLevel);
                    this.setFuelLevel(sign, fuelLevel - Math.min(this.fuelPerTick, fuelLevel));
                }
                if (currentCookProgress >= 50) {
                    for (ItemStack i : items) {
                        ItemStack cooked;
                        if (!ItemUtil.isStackValid(i) || (cooked = ItemUtil.getCookedResult(i)) == null && (!this.allowSmelting || (cooked = ItemUtil.getSmeltedResult(i)) == null) || !inventory.addItem(new ItemStack[]{cooked}).isEmpty()) continue;
                        ItemStack toRemove = i.clone();
                        toRemove.setAmount(1);
                        inventory.removeItem(new ItemStack[]{toRemove});
                        currentCookProgress -= 50;
                        break;
                    }
                }
            } else {
                currentCookProgress = 0;
            }
        }
        if (previousCookProgress != currentCookProgress) {
            sign.setLine(2, (Component)Component.text((int)currentCookProgress));
        }
        sign.update(false);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(SignClickEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        BukkitChangedSign sign = event.getSign();
        String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
        if (!line1.equals("[Cook]")) {
            return;
        }
        ((BukkitSelfTriggerManager)CraftBook.getInstance().getPlatform().getSelfTriggerManager()).registerSelfTrigger(event.getClickedBlock().getLocation());
        CraftBookPlayer p = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        Block b = SignUtil.getBackBlock(event.getClickedBlock());
        Block cb = b.getRelative(0, 2, 0);
        if (cb.getType() == Material.CHEST) {
            Player player = event.getPlayer();
            if (!player.hasPermission("craftbook.cookingpot.refuel")) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    p.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.cookingpot.no-refuel-permissions"));
                }
                event.setCancelled(true);
                return;
            }
            if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
                if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                    p.printError((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (com.sk89q.worldedit.util.formatting.text.Component[])new com.sk89q.worldedit.util.formatting.text.Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
                }
                return;
            }
            CookingPot.CookingPotFuel fuel = CookingPot.CookingPotFuel.getByItemType(p.getItemInHand(HandSide.MAIN_HAND).getType());
            if (ItemUtil.isStackValid(player.getInventory().getItemInMainHand()) && fuel != null) {
                this.increaseFuelLevel(sign, fuel.getFuelCount());
                player.getInventory().setItemInMainHand(ItemUtil.getUsedItem(player.getInventory().getItemInMainHand()));
                p.printInfo((com.sk89q.worldedit.util.formatting.text.Component)TranslatableComponent.of((String)"craftbook.cookingpot.fuel-added"));
                event.setCancelled(true);
            } else if (this.openSign) {
                player.openInventory(((Chest)cb.getState(false)).getBlockInventory());
                event.setCancelled(true);
            }
        }
        sign.update(false);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockDestroy(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event) || !SignUtil.isSign(event.getBlock())) {
            return;
        }
        Sign sign = (Sign)event.getBlock().getState(false);
        for (Side side : Side.values()) {
            String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getSide(side).line(1));
            if (!line1.equals("[Cook]")) continue;
            ((BukkitSelfTriggerManager)CraftBook.getInstance().getPlatform().getSelfTriggerManager()).unregisterSelfTrigger(event.getBlock().getLocation(), SelfTriggerUnregisterEvent.UnregisterReason.BREAK);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        Side side;
        if (!(this.allowRedstone && this.requireFuel && SignUtil.isSign(event.getBlock()) && EventUtil.passesFilter((Event)event))) {
            return;
        }
        Sign bukkitSign = (Sign)event.getBlock().getState(false);
        if (!bukkitSign.getSide(side = bukkitSign.getInteractableSideFor((Position)event.getSource().getLocation())).getLine(1).equals("[Cook]")) {
            return;
        }
        ((BukkitSelfTriggerManager)CraftBook.getInstance().getPlatform().getSelfTriggerManager()).registerSelfTrigger(event.getBlock().getLocation());
        if (event.isOn() && !event.isMinor()) {
            BukkitChangedSign sign = BukkitChangedSign.create(bukkitSign, side);
            this.increaseFuelLevel(sign, event.getNewCurrent());
            sign.update(false);
        }
    }

    public void setFuelLevel(BukkitChangedSign sign, int amount) {
        if (!this.requireFuel) {
            amount = Math.max(amount, 1);
        }
        sign.setLine(3, (Component)Component.text((int)amount));
    }

    public void increaseFuelLevel(BukkitChangedSign sign, int amount) {
        this.setFuelLevel(sign, this.getFuelLevel(sign) + amount);
    }

    public int getFuelLevel(BukkitChangedSign sign) {
        int multiplier;
        try {
            String line3 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(3));
            multiplier = Integer.parseInt(line3);
        }
        catch (Exception e) {
            multiplier = this.requireFuel ? 0 : 1;
            this.setFuelLevel(sign, multiplier);
        }
        return Math.max(this.requireFuel ? 0 : 1, multiplier);
    }
}

