/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import io.papermc.paper.math.Position;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.ChunkAnchor;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.SignUtil;

public class BukkitChunkAnchor
extends ChunkAnchor
implements Listener {
    public BukkitChunkAnchor(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[chunk]")) {
            return;
        }
        CraftBookPlayer lplayer = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!lplayer.hasPermission("craftbook.chunkanchor.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        for (BlockState state : event.getBlock().getChunk().getTileEntities(SignUtil::isSign, false)) {
            if (!(state instanceof Sign)) continue;
            Sign s = (Sign)state;
            for (Side side : Side.values()) {
                if (!PlainTextComponentSerializer.plainText().serialize(s.getSide(side).line(1)).equals("[Chunk]")) continue;
                lplayer.printError((Component)TranslatableComponent.of((String)"craftbook.chunkanchor.already-anchored"));
                SignUtil.cancelSignChange(event);
                return;
            }
        }
        event.line(1, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.text((String)"[Chunk]"));
        lplayer.printInfo((Component)TranslatableComponent.of((String)"craftbook.chunkanchor.create"));
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.updateChunkTicket(event.getChunk());
    }

    @EventHandler
    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.useRedstone || event.isMinor() || !EventUtil.passesFilter((Event)event)) {
            return;
        }
        Block block = event.getBlock();
        if (SignUtil.isSign(block)) {
            Sign bukktiSign = (Sign)block.getState(false);
            BukkitChangedSign sign = BukkitChangedSign.create(block, bukktiSign.getInteractableSideFor((Position)event.getSource().getLocation()));
            String line1 = PlainTextComponentSerializer.plainText().serialize(sign.getLine(1));
            if (!line1.equals("[Chunk]")) {
                return;
            }
            sign.setLine(3, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.text((String)(event.isOn() ? "" : "OFF")));
            sign.update(false);
            this.updateChunkTicket(event.getBlock().getChunk());
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (SignUtil.isSign(event.getBlock())) {
            Sign sign = (Sign)event.getBlock().getState(false);
            for (Side side : Side.values()) {
                if (!sign.getSide(side).getLine(1).equals("[Chunk]")) continue;
                Bukkit.getRegionScheduler().execute((Plugin)CraftBookPlugin.inst(), event.getBlock().getLocation(), () -> this.updateChunkTicket(event.getBlock().getChunk()));
            }
        }
    }

    private void updateChunkTicket(Chunk chunk) {
        boolean shouldAnchor = false;
        block0: for (BlockState state : chunk.getTileEntities(SignUtil::isSign, false)) {
            if (state == null || !(state instanceof Sign)) continue;
            Sign sign = (Sign)state;
            for (Side side : Side.values()) {
                if (!sign.getSide(side).getLine(1).equals("[Chunk]") || this.useRedstone && sign.getSide(side).getLine(3).equals("OFF")) continue;
                shouldAnchor = true;
                continue block0;
            }
        }
        if (shouldAnchor) {
            chunk.addPluginChunkTicket((Plugin)CraftBookPlugin.inst());
        } else {
            chunk.removePluginChunkTicket((Plugin)CraftBookPlugin.inst());
        }
    }
}

