/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.Chairs;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.LocationUtil;
import org.enginehub.craftbook.util.ProtectionUtil;
import org.enginehub.craftbook.util.SignUtil;
import org.jspecify.annotations.Nullable;

public class BukkitChairs
extends Chairs
implements Listener {
    private final Map<UUID, ChairData> chairs = new HashMap<UUID, ChairData>();
    private final NamespacedKey chairDataKey = new NamespacedKey("craftbook", "is_chair");
    private @Nullable BukkitTask tickerTask;

    public BukkitChairs(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        this.tickerTask = Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), (Runnable)new ChairChecker(), 20L, 20L);
    }

    @Override
    public void disable() {
        this.chairs.clear();
        if (this.tickerTask != null) {
            this.tickerTask.cancel();
            this.tickerTask = null;
        }
    }

    private Entity createChairEntity(Block block, @Nullable Vector direction) {
        double height = block.getBoundingBox().getHeight();
        if (Tag.STAIRS.isTagged((Keyed)block.getType())) {
            height = 0.5;
        }
        Location location = block.getLocation().toCenterLocation().subtract(0.0, 2.375 - height, 0.0);
        if (direction != null) {
            location.setDirection(direction);
        }
        ArmorStand chairEntity = (ArmorStand)block.getWorld().spawn(location, ArmorStand.class);
        chairEntity.getPersistentDataContainer().set(this.chairDataKey, PersistentDataType.BYTE, (Object)1);
        chairEntity.setTicksLived(1);
        chairEntity.setInvulnerable(true);
        chairEntity.setGravity(false);
        chairEntity.setSilent(true);
        chairEntity.setVisible(false);
        return chairEntity;
    }

    private void addChair(Player player, Block block, @Nullable Location chairLoc) {
        ChairData chairData;
        Entity ar = null;
        boolean isNew = false;
        if (this.chairs.containsKey(player.getUniqueId())) {
            ar = this.chairs.get((Object)player.getUniqueId()).chairEntity;
        }
        if (ar == null || ar.isDead() || !ar.isValid()) {
            ar = this.createChairEntity(block, chairLoc == null ? null : chairLoc.getDirection());
            isNew = true;
        }
        if (chairLoc != null) {
            ar.setRotation(chairLoc.getYaw(), chairLoc.getPitch());
        }
        Entity far = ar;
        if (ar.isEmpty() && isNew) {
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> {
                if (chairLoc != null) {
                    player.teleport(chairLoc);
                }
                far.addPassenger((Entity)player);
            });
        } else if (ar.isEmpty()) {
            this.removeChair(player);
            return;
        }
        if (this.chairs.containsKey(player.getUniqueId())) {
            ChairData oldChairData = this.chairs.get(player.getUniqueId());
            chairData = new ChairData(ar, oldChairData.location, oldChairData.playerExitPoint);
        } else {
            chairData = new ChairData(ar, block, player.getLocation().clone());
        }
        this.chairs.put(player.getUniqueId(), chairData);
    }

    private void removeChair(Player player) {
        ChairData chairData = this.chairs.get(player.getUniqueId());
        Entity chairEntity = chairData.chairEntity;
        if (chairEntity != null) {
            chairEntity.eject();
            player.eject();
            chairEntity.remove();
            if (this.exitToLastPosition && chairData.playerExitPoint != null) {
                Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                    player.teleport(chairData.playerExitPoint);
                    player.setSneaking(false);
                }, 5L);
            }
        }
        this.chairs.remove(player.getUniqueId());
    }

    private boolean hasSign(Block block) {
        return this.hasSign(block, new HashSet<Location>(), block);
    }

    private boolean hasSign(Block block, Collection<Location> searched, Block original) {
        boolean found = false;
        for (BlockFace face : LocationUtil.getDirectFaces()) {
            Block otherBlock = block.getRelative(face);
            if (searched.contains(otherBlock.getLocation())) continue;
            searched.add(otherBlock.getLocation());
            if (found) break;
            if (!LocationUtil.isWithinSphericalRadius(block, original, (double)this.maxSignDistance)) continue;
            if (SignUtil.isSign(otherBlock) && SignUtil.getFront(otherBlock) == face) {
                found = true;
                break;
            }
            if (!BlockUtil.areBlocksIdentical(block, otherBlock)) continue;
            found = this.hasSign(otherBlock, searched, original);
        }
        return found;
    }

    private boolean hasChair(CraftBookPlayer player) {
        return this.chairs.containsKey(player.getUniqueId());
    }

    private boolean hasChair(Block block) {
        for (ChairData data : this.chairs.values()) {
            if (!block.equals((Object)data.location)) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (this.hasChair(event.getBlock())) {
            CraftBookPlugin.inst().wrapPlayer(event.getPlayer()).printError((Component)TranslatableComponent.of((String)"craftbook.chairs.block-in-use"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDisconnect(PlayerQuitEvent event) {
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (this.hasChair(player)) {
            this.removeChair(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onKick(PlayerKickEvent event) {
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (this.hasChair(player)) {
            this.removeChair(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEntityDismount(EntityDismountEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player bukkitPlayer = (Player)entity;
            CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(bukkitPlayer);
            if (this.hasChair(player)) {
                this.removeChair(bukkitPlayer);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChunkUnload(ChunkUnloadEvent event) {
        for (Entity entity : event.getChunk().getEntities()) {
            if (entity.getType() != EntityType.ARMOR_STAND || !entity.getPersistentDataContainer().has(this.chairDataKey, PersistentDataType.BYTE)) continue;
            entity.remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRightClick(PlayerInteractEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND || event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null || !Blocks.containsFuzzy((Collection)this.allowedBlocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)event.getClickedBlock().getBlockData()))) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!this.allowSneaking.doesPass(player.isSneaking()) || !this.allowHeldBlock && player.isHoldingBlock()) {
            return;
        }
        if (this.requireSign && !this.hasSign(event.getClickedBlock())) {
            return;
        }
        if (!player.hasPermission("craftbook.chairs.use")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.use-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        if (!ProtectionUtil.canUse(event.getPlayer(), event.getClickedBlock().getLocation(), event.getBlockFace(), event.getAction())) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.protection-blocked", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            return;
        }
        event.setCancelled(true);
        if (!LocationUtil.isWithinSphericalRadius(event.getPlayer().getLocation(), event.getClickedBlock().getLocation().toCenterLocation(), (double)this.maxClickRadius)) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.chairs.too-far-away"));
            return;
        }
        if (this.hasChair(player)) {
            ChairData data = this.chairs.get(player.getUniqueId());
            if (!event.getClickedBlock().equals((Object)data.location)) {
                this.removeChair(event.getPlayer());
            } else {
                return;
            }
        }
        if (this.hasChair(event.getClickedBlock())) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.chairs.block-in-use"));
            return;
        }
        if (!event.getClickedBlock().getRelative(0, -1, 0).getType().isSolid()) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.chairs.floating"));
            return;
        }
        if (event.getClickedBlock().getRelative(0, 1, 0).getType().isSolid()) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.chairs.obstructed"));
            return;
        }
        Location chairLoc = event.getClickedBlock().getLocation().add(0.5, 0.0, 0.5);
        BlockData blockData = event.getClickedBlock().getBlockData();
        if (this.faceWhenPossible && blockData instanceof Directional) {
            BlockFace direction = ((Directional)blockData).getFacing().getOppositeFace();
            chairLoc.setYaw(LocationUtil.getYawFromFace(direction));
            chairLoc.setPitch(0.0f);
        } else {
            chairLoc.setPitch(event.getPlayer().getLocation().getPitch());
            chairLoc.setYaw(event.getPlayer().getLocation().getYaw());
        }
        this.addChair(event.getPlayer(), event.getClickedBlock(), chairLoc);
    }

    private class ChairChecker
    implements Runnable {
        private ChairChecker() {
        }

        @Override
        public void run() {
            if (Bukkit.getServer().isPaused()) {
                return;
            }
            for (Map.Entry<UUID, ChairData> pl : BukkitChairs.this.chairs.entrySet()) {
                AttributeInstance maxHealthAttr;
                Player p = Bukkit.getPlayer((UUID)pl.getKey());
                if (p == null || p.isDead() || !p.isValid()) {
                    ChairData data = BukkitChairs.this.chairs.remove(pl.getKey());
                    if (data == null || data.chairEntity == null) continue;
                    Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
                        data.chairEntity.eject();
                        data.chairEntity.remove();
                    }, 5L);
                    continue;
                }
                if (!(Blocks.containsFuzzy((Collection)BukkitChairs.this.allowedBlocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)pl.getValue().location.getBlockData())) && p.getWorld().equals((Object)pl.getValue().location.getWorld()) && LocationUtil.isWithinSphericalRadius(p.getLocation(), pl.getValue().location.getLocation(), 2.0))) {
                    BukkitChairs.this.removeChair(p);
                    continue;
                }
                BukkitChairs.this.addChair(p, pl.getValue().location, null);
                if (BukkitChairs.this.regenHealth && (maxHealthAttr = p.getAttribute(Attribute.MAX_HEALTH)) != null && p.getHealth() < maxHealthAttr.getValue()) {
                    p.setHealth(Math.min(p.getHealth() + BukkitChairs.this.healAmount, maxHealthAttr.getValue()));
                }
                if (!BukkitChairs.this.lowerExhaustion || !((double)p.getExhaustion() > -20.0)) continue;
                p.setExhaustion((float)((double)p.getExhaustion() - 0.1));
            }
        }
    }

    private record ChairData(Entity chairEntity, Block location, @Nullable Location playerExitPoint) {
    }
}

