/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.blocks.Blocks;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Collection;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.util.Vector;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.CraftBookPlayer;
import org.enginehub.craftbook.bukkit.BukkitChangedSign;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.BounceBlocks;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.RegexUtil;
import org.enginehub.craftbook.util.SignUtil;

public class BukkitBounceBlocks
extends BounceBlocks
implements Listener {
    public BukkitBounceBlocks(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Side[] sideArray;
        int n;
        int n2;
        if (event.getFrom().distanceSquared(event.getTo()) <= 1.0E-4) {
            return;
        }
        Block block = event.getFrom().getBlock().getRelative(BlockFace.DOWN);
        if (!Blocks.containsFuzzy((Collection)this.allowedBlocks, (BlockStateHolder)BukkitAdapter.adapt((BlockData)block.getBlockData()))) {
            return;
        }
        if (!event.getPlayer().hasPermission("craftbook.bounceblocks.use")) {
            return;
        }
        CraftBookPlugin.logDebugMessage("Player jumped on a block that is a bounce block!", "bounce-blocks");
        Block sign = block.getRelative(BlockFace.DOWN);
        if (SignUtil.isSign(sign) && (n2 = 0) < (n = (sideArray = Side.values()).length)) {
            Side side = sideArray[n2];
            BukkitChangedSign s = BukkitChangedSign.create(sign, side);
            String signLine1 = PlainTextComponentSerializer.plainText().serialize(s.getLine(1));
            if (signLine1.equals("[Jump]") || signLine1.equals("[Launch]")) {
                boolean requiresManualJump = signLine1.equals("[Jump]");
                if (!(!requiresManualJump || Math.abs(event.getTo().getY() - event.getFrom().getY()) > this.sensitivity && event.getFrom().getY() - (double)event.getFrom().getBlockY() < 0.25)) {
                    return;
                }
                String signLine2 = PlainTextComponentSerializer.plainText().serialize(s.getLine(2, CraftBookPlugin.inst().wrapPlayer(event.getPlayer())));
                CraftBookPlugin.logDebugMessage("Jump sign found where player jumped!", "bounce-blocks");
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                boolean straight = signLine2.startsWith("!");
                String[] bits = RegexUtil.COMMA_PATTERN.split(signLine2.replace("!", ""));
                if (bits.length == 0) {
                    y = 0.5;
                } else if (bits.length == 1) {
                    try {
                        y = Double.parseDouble(bits[0]);
                    }
                    catch (NumberFormatException e) {
                        y = 0.5;
                    }
                } else {
                    x = Double.parseDouble(bits[0]);
                    y = Double.parseDouble(bits[1]);
                    z = Double.parseDouble(bits[2]);
                }
                if (!straight) {
                    Vector facingBasis = event.getTo().toVector().subtract(event.getFrom().toVector()).setY(0);
                    if (facingBasis.lengthSquared() <= 1.0E-4) {
                        facingBasis = event.getTo().getDirection().clone().setY(0);
                    }
                    Vector forward = facingBasis.normalize();
                    Vector up = new Vector(0, 1, 0);
                    Vector right = forward.clone().crossProduct(up).normalize();
                    up = right.clone().crossProduct(forward).normalize();
                    Vector worldVel = forward.multiply(x).add(up.multiply(y)).add(right.multiply(z));
                    x = worldVel.getX();
                    z = worldVel.getZ();
                }
                event.getPlayer().setVelocity(new Vector(x, y, z));
                event.getPlayer().setFallDistance(-1000.0f);
                event.getPlayer().playSound(block.getLocation(), Sound.ENTITY_WIND_CHARGE_WIND_BURST, 1.0f, 1.0f);
                event.getPlayer().spawnParticle(Particle.GUST, block.getLocation().add(0.5, 1.5, 0.5), 1, 0.0, 0.0, 0.0, 0.1);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onSignChange(SignChangeEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        String signLine1 = PlainTextComponentSerializer.plainText().serialize(event.line(1));
        if (!signLine1.equalsIgnoreCase("[Jump]") && !signLine1.equalsIgnoreCase("[Launch]")) {
            return;
        }
        CraftBookPlayer player = CraftBookPlugin.inst().wrapPlayer(event.getPlayer());
        if (!player.hasPermission("craftbook.bounceblocks.create")) {
            if (CraftBook.getInstance().getPlatform().getConfiguration().showPermissionMessages) {
                player.printError((Component)TranslatableComponent.of((String)"craftbook.mechanisms.create-permission", (Component[])new Component[]{TextComponent.of((String)this.getMechanicType().getName())}));
            }
            SignUtil.cancelSignChange(event);
            return;
        }
        try {
            String signLine2 = PlainTextComponentSerializer.plainText().serialize(event.line(2));
            String[] bits = RegexUtil.COMMA_PATTERN.split(signLine2.replace("!", ""));
            if (bits.length == 1) {
                Double.parseDouble(bits[0]);
            } else if (bits.length == 3) {
                Double.parseDouble(bits[0]);
                Double.parseDouble(bits[1]);
                Double.parseDouble(bits[2]);
            } else if (bits.length != 0) {
                throw new Exception("Invalid number of velocity components");
            }
        }
        catch (Exception e) {
            player.printError((Component)TranslatableComponent.of((String)"craftbook.bounceblocks.invalid-velocity"));
            SignUtil.cancelSignChange(event);
            return;
        }
        if (signLine1.equalsIgnoreCase("[Jump]")) {
            event.line(1, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.text((String)"[Jump]"));
        } else if (signLine1.equalsIgnoreCase("[Launch]")) {
            event.line(1, (net.kyori.adventure.text.Component)net.kyori.adventure.text.Component.text((String)"[Launch]"));
        }
        player.printInfo((Component)TranslatableComponent.of((String)"craftbook.bounceblocks.create"));
    }
}

