/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.block.BlockType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.enginehub.craftbook.CraftBook;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.bukkit.events.SourcedBlockRedstoneEvent;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.BetterSponge;
import org.enginehub.craftbook.util.EventUtil;
import org.enginehub.craftbook.util.LocationUtil;

public class BukkitBetterSponge
extends BetterSponge
implements Listener {
    public BukkitBetterSponge(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockFromTo(BlockFromToEvent event) {
        if (event.getBlock().getType() != Material.WATER) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        for (int cx = -this.radius; cx <= this.radius; ++cx) {
            for (int cy = -this.radius; cy <= this.radius; ++cy) {
                for (int cz = -this.radius; cz <= this.radius; ++cz) {
                    BlockType blockType;
                    Block sponge = event.getToBlock().getRelative(cx, cy, cz);
                    if (this.sphereRange && !LocationUtil.isWithinSphericalRadius(sponge, event.getToBlock(), (double)this.radius) || !this.isValidSponge(blockType = BukkitAdapter.asBlockType((Material)sponge.getType())) || this.redstone && !sponge.isBlockIndirectlyPowered()) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockPlace(BlockPlaceEvent event) {
        BlockType blockType = BukkitAdapter.asBlockType((Material)event.getBlock().getType());
        if (!this.isValidSponge(blockType)) {
            return;
        }
        if (this.redstone && !event.getBlock().isBlockIndirectlyPowered()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        this.removeWater(event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        BlockType blockType = BukkitAdapter.asBlockType((Material)event.getBlock().getType());
        if (!this.isValidSponge(blockType)) {
            return;
        }
        if (this.redstone && !event.getBlock().isBlockIndirectlyPowered()) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> this.addWater(event.getBlock()));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.redstone || event.isMinor()) {
            return;
        }
        BlockType blockType = BukkitAdapter.asBlockType((Material)event.getBlock().getType());
        if (!this.isValidSponge(blockType)) {
            return;
        }
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (!event.isOn()) {
            Bukkit.getScheduler().runTask((Plugin)CraftBookPlugin.inst(), () -> this.addWater(event.getBlock()));
        } else {
            this.removeWater(event.getBlock());
        }
    }

    private void setBlockToWater(Block block, Block source) {
        if (block.getType().isAir()) {
            Levelled levelled;
            int sourceLevel;
            BlockData sourceData = source.getBlockData();
            int level = 0;
            if (sourceData instanceof Levelled && (sourceLevel = (levelled = (Levelled)sourceData).getLevel()) != 0) {
                level = Math.max(levelled.getLevel() + 1, 7);
            }
            if (CraftBook.getInstance().getPlatform().getConfiguration().obeyPluginProtections) {
                BlockFromToEvent event = new BlockFromToEvent(source, block);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    Levelled data = (Levelled)Bukkit.createBlockData((Material)Material.WATER);
                    data.setLevel(level);
                    block.setBlockData((BlockData)data);
                }
            } else {
                Levelled data = (Levelled)Bukkit.createBlockData((Material)Material.WATER);
                data.setLevel(level);
                block.setBlockData((BlockData)data);
            }
        }
    }

    public void removeWater(Block block) {
        for (int cx = -this.radius; cx <= this.radius; ++cx) {
            for (int cy = -this.radius; cy <= this.radius; ++cy) {
                for (int cz = -this.radius; cz <= this.radius; ++cz) {
                    Block water = block.getRelative(cx, cy, cz);
                    if (this.sphereRange && !LocationUtil.isWithinSphericalRadius(water, block, (double)this.radius)) continue;
                    BlockType waterType = BukkitAdapter.asBlockType((Material)water.getType());
                    if (this.isRemovableWater(waterType)) {
                        water.setType(Material.AIR);
                        continue;
                    }
                    BlockData data = water.getBlockData();
                    if (!(data instanceof Waterlogged)) continue;
                    Waterlogged waterlogged = (Waterlogged)data;
                    waterlogged.setWaterlogged(false);
                    water.setBlockData((BlockData)waterlogged);
                }
            }
        }
    }

    public void addWater(Block block) {
        BlockType waterType;
        Block water;
        int cz;
        int cy;
        int cx = -this.radius - 1;
        for (cy = -this.radius - 1; cy <= this.radius + 1; ++cy) {
            for (cz = -this.radius - 1; cz <= this.radius + 1; ++cz) {
                water = block.getRelative(cx, cy, cz);
                if (this.sphereRange && !LocationUtil.isWithinSphericalRadius(water, block, (double)(this.radius + 1)) || !this.isRemovableWater(waterType = BukkitAdapter.asBlockType((Material)water.getType()))) continue;
                this.setBlockToWater(water.getRelative(1, 0, 0), water);
            }
        }
        cx = this.radius + 1;
        for (cy = -this.radius - 1; cy <= this.radius + 1; ++cy) {
            for (cz = -this.radius - 1; cz <= this.radius + 1; ++cz) {
                water = block.getRelative(cx, cy, cz);
                if (this.sphereRange && !LocationUtil.isWithinSphericalRadius(water, block, (double)(this.radius + 1)) || !this.isRemovableWater(waterType = BukkitAdapter.asBlockType((Material)water.getType()))) continue;
                this.setBlockToWater(water.getRelative(-1, 0, 0), water);
            }
        }
        cy = -this.radius - 1;
        for (cx = -this.radius - 1; cx <= this.radius + 1; ++cx) {
            for (cz = -this.radius - 1; cz <= this.radius + 1; ++cz) {
                water = block.getRelative(cx, cy, cz);
                if (this.sphereRange && !LocationUtil.isWithinSphericalRadius(water, block, (double)(this.radius + 1)) || !this.isRemovableWater(waterType = BukkitAdapter.asBlockType((Material)water.getType()))) continue;
                this.setBlockToWater(water.getRelative(0, 1, 0), water);
            }
        }
        cy = this.radius + 1;
        for (cx = -this.radius - 1; cx <= this.radius + 1; ++cx) {
            for (cz = -this.radius - 1; cz <= this.radius + 1; ++cz) {
                water = block.getRelative(cx, cy, cz);
                if (this.sphereRange && !LocationUtil.isWithinSphericalRadius(water, block, (double)(this.radius + 1)) || !this.isRemovableWater(waterType = BukkitAdapter.asBlockType((Material)water.getType()))) continue;
                this.setBlockToWater(water.getRelative(0, -1, 0), water);
            }
        }
        cz = -this.radius - 1;
        for (cx = -this.radius - 1; cx <= this.radius + 1; ++cx) {
            for (cy = -this.radius - 1; cy <= this.radius + 1; ++cy) {
                water = block.getRelative(cx, cy, cz);
                if (this.sphereRange && !LocationUtil.isWithinSphericalRadius(water, block, (double)(this.radius + 1)) || !this.isRemovableWater(waterType = BukkitAdapter.asBlockType((Material)water.getType()))) continue;
                this.setBlockToWater(water.getRelative(0, 0, 1), water);
            }
        }
        cz = this.radius + 1;
        for (cx = -this.radius - 1; cx <= this.radius + 1; ++cx) {
            for (cy = -this.radius - 1; cy <= this.radius + 1; ++cy) {
                water = block.getRelative(cx, cy, cz);
                if (this.sphereRange && !LocationUtil.isWithinSphericalRadius(water, block, (double)(this.radius + 1)) || !this.isRemovableWater(waterType = BukkitAdapter.asBlockType((Material)water.getType()))) continue;
                this.setBlockToWater(water.getRelative(0, 0, -1), water);
            }
        }
    }
}

