/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.craftbook.bukkit.mechanics;

import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.enginehub.craftbook.bukkit.CraftBookPlugin;
import org.enginehub.craftbook.mechanic.CraftBookMechanic;
import org.enginehub.craftbook.mechanic.MechanicType;
import org.enginehub.craftbook.mechanics.BetterPlants;
import org.enginehub.craftbook.util.BlockUtil;
import org.enginehub.craftbook.util.EventUtil;
import org.jspecify.annotations.Nullable;

public class BukkitBetterPlants
extends BetterPlants
implements Listener {
    private @Nullable BukkitTask growthTask;
    private @Nullable Bisected topHalfData = null;

    public BukkitBetterPlants(MechanicType<? extends CraftBookMechanic> mechanicType) {
        super(mechanicType);
    }

    @Override
    public void enable() {
        if (this.fernFarming) {
            this.growthTask = Bukkit.getScheduler().runTaskTimer((Plugin)CraftBookPlugin.inst(), (Runnable)new GrowthTicker(), 2L, 2L);
            this.topHalfData = (Bisected)Material.LARGE_FERN.createBlockData();
            this.topHalfData.setHalf(Bisected.Half.TOP);
        }
    }

    @Override
    public void disable() {
        if (this.growthTask != null) {
            this.growthTask.cancel();
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!EventUtil.passesFilter((Event)event)) {
            return;
        }
        if (this.fernFarming) {
            BukkitBetterPlants.handleFernBreak(event.getBlock());
        }
    }

    private static void handleFernBreak(Block block) {
        Material type = block.getType();
        if (type != Material.LARGE_FERN) {
            return;
        }
        Bisected data = (Bisected)block.getBlockData();
        if (data.getHalf() != Bisected.Half.TOP) {
            return;
        }
        Block below = block.getRelative(BlockFace.DOWN);
        Material belowType = below.getType();
        if (belowType != Material.LARGE_FERN) {
            return;
        }
        Bisected belowData = (Bisected)below.getBlockData();
        if (belowData.getHalf() != Bisected.Half.BOTTOM) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)CraftBookPlugin.inst(), () -> {
            block.getWorld().dropItemNaturally(block.getLocation().toCenterLocation(), new ItemStack(Material.FERN));
            below.setType(Material.FERN);
        }, 2L);
    }

    private class GrowthTicker
    implements Runnable {
        private GrowthTicker() {
        }

        @Override
        public void run() {
            if (Bukkit.getServer().isPaused()) {
                return;
            }
            for (World world : Bukkit.getWorlds()) {
                int x = 0;
                int y = 0;
                int z = 0;
                if (BukkitBetterPlants.this.fastTickRandoms) {
                    x = ThreadLocalRandom.current().nextInt(16);
                    y = ThreadLocalRandom.current().nextInt(world.getMinHeight(), world.getMaxHeight());
                    z = ThreadLocalRandom.current().nextInt(16);
                }
                for (Chunk chunk : world.getLoadedChunks()) {
                    Block aboveBlock;
                    if (!BukkitBetterPlants.this.fastTickRandoms) {
                        x = ThreadLocalRandom.current().nextInt(16);
                        y = ThreadLocalRandom.current().nextInt(world.getMinHeight(), world.getMaxHeight());
                        z = ThreadLocalRandom.current().nextInt(16);
                    }
                    Block block = chunk.getBlock(x, y, z);
                    if (!BukkitBetterPlants.this.fernFarming || block.getType() != Material.FERN || BukkitBetterPlants.this.topHalfData == null || !BlockUtil.isBlockReplacable((aboveBlock = block.getRelative(0, 1, 0)).getType())) continue;
                    block.setType(Material.LARGE_FERN, false);
                    aboveBlock.setBlockData((BlockData)BukkitBetterPlants.this.topHalfData, false);
                }
            }
        }
    }
}

